/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.network.packet;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.api.MoobloomVariant;
import com.faboslav.friendsandfoes.common.api.MoobloomVariantManager;
import com.faboslav.friendsandfoes.common.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.common.network.MessageHandler;
import com.faboslav.friendsandfoes.common.network.base.Packet;
import com.faboslav.friendsandfoes.common.network.base.PacketContext;
import com.faboslav.friendsandfoes.common.network.base.PacketHandler;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record MoobloomVariantsSyncPacket(List<MoobloomVariant> moobloomVariants) implements Packet<MoobloomVariantsSyncPacket>
{
    public static Gson gson = new GsonBuilder().create();
    public static final ResourceLocation ID = FriendsAndFoes.makeID("moobloom_variants_sync_packet");
    public static final Handler HANDLER = new Handler();

    public static void sendToClient(DatapackSyncEvent event) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(new MoobloomVariantsSyncPacket(MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariants()), (Player)event.player());
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PacketHandler<MoobloomVariantsSyncPacket> getHandler() {
        return HANDLER;
    }

    public static class Handler
    implements PacketHandler<MoobloomVariantsSyncPacket> {
        @Override
        public PacketContext handle(MoobloomVariantsSyncPacket packet) {
            return (player, level) -> MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.setMoobloomVariants(packet.moobloomVariants());
        }

        @Override
        public MoobloomVariantsSyncPacket decode(FriendlyByteBuf buf) {
            ArrayList<MoobloomVariant> parsedMoobloomVariants = new ArrayList<MoobloomVariant>();
            CompoundTag data = buf.m_130260_();
            if (data == null) {
                FriendsAndFoes.getLogger().error("Moobloom Variant packet is empty");
                return new MoobloomVariantsSyncPacket(parsedMoobloomVariants);
            }
            ListTag moobloomVariants = data.m_128437_("moobloom_variants", 10);
            for (Tag moobloomVariant : moobloomVariants) {
                DataResult parsedMoobloomVariant = MoobloomVariant.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)moobloomVariant);
                parsedMoobloomVariant.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to parse Moobloom Variant packet entry: {}", error));
                parsedMoobloomVariant.result().ifPresent(parsedMoobloomVariants::add);
            }
            return new MoobloomVariantsSyncPacket(parsedMoobloomVariants);
        }

        @Override
        public void encode(MoobloomVariantsSyncPacket packet, FriendlyByteBuf buf) {
            CompoundTag data = new CompoundTag();
            ListTag parsedMoobloomVariants = new ListTag();
            for (MoobloomVariant moobloomVariant : packet.moobloomVariants()) {
                DataResult parsedMoobloomVariant = MoobloomVariant.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)moobloomVariant);
                parsedMoobloomVariant.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to encode Moobloom Variant packet entry: {}", error));
                parsedMoobloomVariant.result().ifPresent(arg_0 -> parsedMoobloomVariants.add(arg_0));
            }
            data.m_128365_("moobloom_variants", (Tag)parsedMoobloomVariants);
            buf.m_130079_((Tag)data);
        }
    }
}

