/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.platform.forge;

import com.faboslav.friendsandfoes.common.network.base.Packet;
import com.faboslav.friendsandfoes.common.network.base.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class PacketChannelManagerImpl {
    public static final Map<ResourceLocation, Channel> CHANNELS = new HashMap<ResourceLocation, Channel>();

    public static void registerChannel(ResourceLocation name) {
        Channel channel = new Channel(0, ChannelBuilder.named((ResourceLocation)name).simpleChannel());
        CHANNELS.put(name, channel);
    }

    public static <T extends Packet<T>> void registerS2CPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        ++channel.packets;
        channel.channel.messageBuilder(packetClass).encoder(handler::encode).decoder(handler::decode).consumerNetworkThread((msg, ctx) -> {
            ctx.enqueueWork(() -> {
                Player player;
                Object object = player = ctx.getSender() == null ? PacketChannelManagerImpl.getPlayer() : null;
                if (player != null) {
                    handler.handle(msg).apply(player, player.m_9236_());
                }
            });
            ctx.setPacketHandled(true);
        }).add();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static <T extends Packet<T>> void registerC2SPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        ++channel.packets;
        channel.channel.messageBuilder(packetClass).encoder(handler::encode).decoder(handler::decode).consumerNetworkThread((msg, ctx) -> {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                ctx.enqueueWork(() -> PacketChannelManagerImpl.lambda$registerC2SPacket$2(handler, msg, (Player)player));
            }
            ctx.setPacketHandled(true);
        });
    }

    public static <T extends Packet<T>> void sendToServer(ResourceLocation name, T packet) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        channel.channel.send(packet, PacketDistributor.SERVER.noArg());
    }

    public static <T extends Packet<T>> void sendToPlayer(ResourceLocation name, T packet, Player player) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            channel.channel.send(packet, PacketDistributor.PLAYER.with((Object)serverPlayer));
        }
    }

    private static /* synthetic */ void lambda$registerC2SPacket$2(PacketHandler handler, Packet msg, Player player) {
        handler.handle(msg).apply(player, player.m_9236_());
    }

    private static final class Channel {
        private int packets;
        private final SimpleChannel channel;

        private Channel(int packets, SimpleChannel channel) {
            this.packets = packets;
            this.channel = channel;
        }
    }
}

