/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.advancements.criterion;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesCriterias;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.storage.loot.LootContext;

public final class ActivateZombieHorseTrapCriterion
extends SimpleCriterionTrigger<Conditions> {
    public Conditions conditionsFromJson(JsonObject jsonObject, Optional<ContextAwarePredicate> optional, DeserializationContext advancementEntityPredicateDeserializer) {
        Optional optional2 = EntityPredicate.fromJson((JsonObject)jsonObject, (String)"lightning", (DeserializationContext)advancementEntityPredicateDeserializer);
        return new Conditions(optional, optional2);
    }

    public void trigger(ServerPlayer player, LightningBolt lightning) {
        LootContext lootContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)lightning);
        this.trigger(player, conditions -> conditions.matches(lootContext));
    }

    public static class Conditions
    extends AbstractCriterionTriggerInstance {
        private final Optional<ContextAwarePredicate> lightning;

        public Conditions(Optional<ContextAwarePredicate> playerPredicate, Optional<ContextAwarePredicate> entity) {
            super(playerPredicate);
            this.lightning = entity;
        }

        public static Criterion<Conditions> any() {
            return FriendsAndFoesCriterias.ACTIVATE_ZOMBIE_HORSE_TRAP.createCriterion((CriterionTriggerInstance)new Conditions(Optional.empty(), Optional.empty()));
        }

        public static Criterion<Conditions> create(EntityPredicate.Builder builder) {
            return FriendsAndFoesCriterias.ACTIVATE_ZOMBIE_HORSE_TRAP.createCriterion((CriterionTriggerInstance)new Conditions(Optional.empty(), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)builder))));
        }

        public boolean matches(LootContext entity) {
            return this.lightning.isEmpty() || this.lightning.get().matches(entity);
        }

        public JsonObject serializeToJson() {
            JsonObject jsonObject = super.serializeToJson();
            this.lightning.ifPresent(lootContextPredicate -> jsonObject.add("lightning", lootContextPredicate.toJson()));
            return jsonObject;
        }
    }
}

