/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.block.CopperButtonBlock;
import com.faboslav.friendsandfoes.common.block.FriendsAndFoesOxidizable;
import com.faboslav.friendsandfoes.common.block.OnUseOxidizable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class OxidizableButtonBlock
extends CopperButtonBlock
implements FriendsAndFoesOxidizable {
    private final WeatheringCopper.WeatherState oxidationLevel;

    public OxidizableButtonBlock(WeatheringCopper.WeatherState oxidationLevel, BlockBehaviour.Properties settings, int pressTicks) {
        super(settings, pressTicks);
        this.oxidationLevel = oxidationLevel;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.onRandomTick(state, world, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return FriendsAndFoesOxidizable.getIncreasedOxidationBlock(state.getBlock()).isPresent();
    }

    public WeatheringCopper.WeatherState getDegradationLevel() {
        return this.oxidationLevel;
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult actionResult = OnUseOxidizable.onOxidizableUse(state, world, pos, player, hand, hit);
        if (actionResult.consumesAction()) {
            return actionResult;
        }
        return super.use(state, world, pos, player, hand, hit);
    }
}

