/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RascalEntityModel<T extends RascalEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_BAG = "bag";
    private static final String MODEL_PART_LEFT_ARM = "leftArm";
    private static final String MODEL_PART_RIGHT_ARM = "rightArm";
    private static final String MODEL_PART_LEFT_LEG = "leftLeg";
    private static final String MODEL_PART_RIGHT_LEG = "rightLeg";
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart bag;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public RascalEntityModel(ModelPart root) {
        super(root);
        this.head = this.root.getChild(MODEL_PART_HEAD);
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.bag = this.root.getChild(MODEL_PART_BAG);
        this.leftArm = this.root.getChild(MODEL_PART_LEFT_ARM);
        this.rightArm = this.root.getChild(MODEL_PART_RIGHT_ARM);
        this.leftLeg = this.root.getChild(MODEL_PART_LEFT_LEG);
        this.rightLeg = this.root.getChild(MODEL_PART_RIGHT_LEG);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild(MODEL_PART_HEAD, CubeListBuilder.create().texOffs(0, 52).addBox(-4.0f, -2.0f, -5.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 36).addBox(-4.0f, -3.0f, -5.0f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)9.0f, (float)-5.0f));
        root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 0.0f, -4.0f, 12.0f, 15.0f, 8.0f, new CubeDeformation(-0.01f)).texOffs(0, 23).addBox(-6.0f, 12.0f, -4.0f, 12.0f, 5.0f, 8.0f, new CubeDeformation(-0.5f)).texOffs(44, 0).addBox(3.0f, 0.0f, -4.0f, 2.0f, 15.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        root.addOrReplaceChild(MODEL_PART_BAG, CubeListBuilder.create().texOffs(0, 36).addBox(-4.0f, -0.5f, -0.5f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)7.5f, (float)4.5f));
        root.addOrReplaceChild(MODEL_PART_LEFT_ARM, CubeListBuilder.create().texOffs(50, 28).mirror().addBox(-3.0f, -2.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-6.0f, (float)11.0f, (float)0.0f));
        root.addOrReplaceChild(MODEL_PART_RIGHT_ARM, CubeListBuilder.create().texOffs(50, 28).addBox(0.0f, -2.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)11.0f, (float)0.0f));
        root.addOrReplaceChild(MODEL_PART_LEFT_LEG, CubeListBuilder.create().texOffs(28, 54).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)18.0f, (float)0.0f));
        root.addOrReplaceChild(MODEL_PART_RIGHT_LEG, CubeListBuilder.create().texOffs(28, 54).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)18.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setAngles(T rascal, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updateMovementKeyframeAnimations((AnimatedEntity)rascal, limbAngle, limbDistance, 1.5f, 2.5f);
        this.updateKeyframeAnimations((AnimatedEntity)rascal, animationProgress);
    }
}

