/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.model.IceologerIceChunkModel;
import com.faboslav.friendsandfoes.common.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class IceologerIceChunkRenderer
extends EntityRenderer<IceologerIceChunkEntity> {
    private static final ResourceLocation TEXTURE = FriendsAndFoes.makeID("textures/entity/illager/ice_chunk.png");
    private final IceologerIceChunkModel<IceologerIceChunkEntity> model;

    public IceologerIceChunkRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new IceologerIceChunkModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.ICEOLOGER_ICE_CHUNK_LAYER));
    }

    public void render(IceologerIceChunkEntity iceChunk, float f, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        float summonAnimationProgress = Mth.lerp((float)Minecraft.getInstance().getFrameTime(), (float)iceChunk.getLastSummonAnimationProgress(), (float)iceChunk.getSummonAnimationProgress());
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f - iceChunk.getYRot()));
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(this.model.renderType(TEXTURE));
        this.model.setAngles(iceChunk, 0.0f, 0.0f, 0.0f, iceChunk.getYRot(), iceChunk.getXRot());
        this.model.prepareMobModel(iceChunk, 0.0f, 0.0f, tickDelta);
        matrixStack.scale(summonAnimationProgress, summonAnimationProgress, summonAnimationProgress);
        this.model.renderToBuffer(matrixStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popPose();
        super.render((Entity)iceChunk, f, tickDelta, matrixStack, vertexConsumerProvider, i);
    }

    public ResourceLocation getTexture(IceologerIceChunkEntity entity) {
        return TEXTURE;
    }
}

