/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.model.MaulerEntityModel;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class MaulerEntityRenderer
extends MobRenderer<MaulerEntity, MaulerEntityModel<MaulerEntity>> {
    private static final float SHADOW_RADIUS = 0.35f;

    public MaulerEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new MaulerEntityModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.MAULER_LAYER)), 0.35f);
    }

    public ResourceLocation getTexture(MaulerEntity mauler) {
        return FriendsAndFoes.makeID("textures/entity/mauler/" + mauler.getMaulerType().getName() + ".png");
    }

    public void render(MaulerEntity mauler, float f, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        this.shadowRadius = mauler.isBurrowedDown() ? 0.0f : 0.35f;
        super.render((Mob)mauler, f, tickDelta, matrixStack, vertexConsumerProvider, i);
    }

    protected void scale(MaulerEntity mauler, PoseStack matrixStack, float f) {
        float size = mauler.getSize();
        matrixStack.scale(size, size, size);
    }
}

