/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemGoToHomePositionTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemLookAroundTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemSleepTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemWanderAroundTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public final class TuffGolemBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super TuffGolemEntity>>> SENSORS;
    private static final UniformInt SLEEP_COOLDOWN_PROVIDER;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.provider(MEMORY_MODULES, SENSORS);
        Brain brain = profile.makeBrain(dynamic);
        TuffGolemBrain.addCoreActivities((Brain<TuffGolemEntity>)brain);
        TuffGolemBrain.addHomeActivities((Brain<TuffGolemEntity>)brain);
        TuffGolemBrain.addIdleActivities((Brain<TuffGolemEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void addCoreActivities(Brain<TuffGolemEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new TuffGolemLookAroundTask(45, 90)), (Object)((Object)new TuffGolemWanderAroundTask()), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get())));
    }

    private static void addHomeActivities(Brain<TuffGolemEntity> brain) {
        brain.addActivityWithConditions(FriendsAndFoesActivities.TUFF_GOLEM_HOME.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new TuffGolemGoToHomePositionTask())), (Object)Pair.of((Object)1, (Object)((Object)new TuffGolemSleepTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addIdleActivities(Brain<TuffGolemEntity> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)3), (Object)Pair.of((Object)SetEntityLookTargetSometimes.create(FriendsAndFoesEntityTypes.COPPER_GOLEM.get(), (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)2), (Object)Pair.of((Object)SetEntityLookTargetSometimes.create(FriendsAndFoesEntityTypes.TUFF_GOLEM.get(), (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)2), (Object)Pair.of((Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.IRON_GOLEM, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)1)))), (Object)Pair.of((Object)1, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new DoNothing(60, 80), (Object)2), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(TuffGolemBrain::isNotImmobilized, (OneShot)RandomStroll.stroll((float)0.6f)), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(TuffGolemBrain::isNotImmobilized, (OneShot)SetWalkTargetFromLookTarget.create((float)0.6f, (int)2)), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivities(TuffGolemEntity tuffGolem) {
        tuffGolem.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)FriendsAndFoesActivities.TUFF_GOLEM_HOME.get(), (Object)Activity.IDLE));
    }

    public static void resetSleepCooldown(TuffGolemEntity tuffGolem) {
        tuffGolem.getBrain().eraseMemory(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get());
    }

    public static void setSleepCooldown(TuffGolemEntity tuffGolem) {
        tuffGolem.getBrain().setMemory(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)SLEEP_COOLDOWN_PROVIDER.sample(tuffGolem.getRandom()));
    }

    private static boolean isNotImmobilized(TuffGolemEntity tuffGolem) {
        return tuffGolem.isNotImmobilized();
    }

    static {
        SENSORS = List.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS);
        MEMORY_MODULES = List.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.PATH, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get());
        SLEEP_COOLDOWN_PROVIDER = UniformInt.of((int)6000, (int)8000);
    }
}

