/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem;

import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public final class CopperGolemTravelToButtonTask
extends Behavior<CopperGolemEntity> {
    private static final int MAX_TRAVELLING_TICKS = 600;
    private static final float WITHING_DISTANCE = 1.5f;

    public CopperGolemTravelToButtonTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), MemoryStatus.VALUE_ABSENT), 600);
    }

    protected boolean shouldRun(ServerLevel world, CopperGolemEntity copperGolem) {
        GlobalPos buttonPos = copperGolem.getButtonPos();
        return buttonPos != null && copperGolem.isButtonValidToBePressed(buttonPos.pos());
    }

    protected void run(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        this.walkTowardsButton(copperGolem);
    }

    protected boolean shouldKeepRunning(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        GlobalPos buttonPos = copperGolem.getButtonPos();
        return buttonPos != null && copperGolem.isButtonValidToBePressed(buttonPos.pos()) && (!buttonPos.pos().closerToCenterThan((Position)copperGolem.position(), 1.5) || copperGolem.getNavigation().isInProgress()) && !copperGolem.isOxidized();
    }

    protected void keepRunning(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        if (copperGolem.getNavigation().isInProgress()) {
            return;
        }
        this.walkTowardsButton(copperGolem);
    }

    protected void finishRunning(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        copperGolem.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        GlobalPos buttonPos = copperGolem.getButtonPos();
        if (!(buttonPos == null || buttonPos.pos().closerToCenterThan((Position)copperGolem.position(), 1.5) && copperGolem.isButtonValidToBePressed(buttonPos.pos()))) {
            copperGolem.getBrain().eraseMemory(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get());
        }
    }

    private void walkTowardsButton(CopperGolemEntity copperGolem) {
        GlobalPos buttonPos = copperGolem.getButtonPos();
        if (buttonPos == null) {
            return;
        }
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)copperGolem, (BlockPos)new BlockPos((Vec3i)buttonPos.pos()), (float)1.0f, (int)0);
    }
}

