/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.init;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.IceologerEntity;
import com.faboslav.friendsandfoes.common.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.events.lifecycle.AddSpawnBiomeModificationsEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntityAttributesEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntitySpawnRestrictionsEvent;
import com.faboslav.friendsandfoes.common.init.registry.RegistryEntry;
import com.faboslav.friendsandfoes.common.init.registry.ResourcefulRegistries;
import com.faboslav.friendsandfoes.common.init.registry.ResourcefulRegistry;
import com.faboslav.friendsandfoes.common.platform.CustomSpawnGroup;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.levelgen.Heightmap;

public final class FriendsAndFoesEntityTypes {
    public static final ResourcefulRegistry<EntityType<?>> ENTITY_TYPES = ResourcefulRegistries.create(BuiltInRegistries.ENTITY_TYPE, "friendsandfoes");
    public static boolean previousUseChoiceTypeRegistrations = SharedConstants.CHECK_DATA_FIXER_SCHEMA;
    public static final RegistryEntry<EntityType<CopperGolemEntity>> COPPER_GOLEM;
    public static final RegistryEntry<EntityType<CrabEntity>> CRAB;
    public static final RegistryEntry<EntityType<GlareEntity>> GLARE;
    public static final RegistryEntry<EntityType<IceologerEntity>> ICEOLOGER;
    public static final RegistryEntry<EntityType<IceologerIceChunkEntity>> ICE_CHUNK;
    public static final RegistryEntry<EntityType<MaulerEntity>> MAULER;
    public static final RegistryEntry<EntityType<MoobloomEntity>> MOOBLOOM;
    public static final RegistryEntry<EntityType<RascalEntity>> RASCAL;
    public static final RegistryEntry<EntityType<TuffGolemEntity>> TUFF_GOLEM;
    public static final RegistryEntry<EntityType<WildfireEntity>> WILDFIRE;
    public static final RegistryEntry<EntityType<PlayerIllusionEntity>> PLAYER_ILLUSION;

    public static void registerEntityAttributes(RegisterEntityAttributesEvent event) {
        event.register(COPPER_GOLEM.get(), CopperGolemEntity.createCopperGolemAttributes());
        event.register(CRAB.get(), CrabEntity.createCrabAttributes());
        event.register(GLARE.get(), GlareEntity.createGlareAttributes());
        event.register(ICEOLOGER.get(), IceologerEntity.createIceologerAttributes());
        event.register(MAULER.get(), MaulerEntity.createMaulerAttributes());
        event.register(MOOBLOOM.get(), MoobloomEntity.createAttributes());
        event.register(RASCAL.get(), RascalEntity.createRascalAttributes());
        event.register(TUFF_GOLEM.get(), TuffGolemEntity.createTuffGolemAttributes());
        event.register(WILDFIRE.get(), WildfireEntity.createWildfireAttributes());
        event.register(PLAYER_ILLUSION.get(), PlayerIllusionEntity.createMobAttributes());
    }

    public static void registerEntitySpawnRestrictions(RegisterEntitySpawnRestrictionsEvent event) {
        event.register(CRAB.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrabEntity::canSpawn);
        event.register(GLARE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GlareEntity::canSpawn);
        event.register(ICEOLOGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::checkPatrollingMonsterSpawnRules);
        event.register(MAULER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MaulerEntity::canSpawn);
        event.register(MOOBLOOM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoobloomEntity::canSpawn);
        event.register(RASCAL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RascalEntity::canSpawn);
    }

    public static void addSpawnBiomeModifications(AddSpawnBiomeModificationsEvent event) {
        FriendsAndFoesConfig config = FriendsAndFoes.getConfig();
        if (config.enableCrab && config.enableCrabSpawn) {
            event.add(FriendsAndFoesTags.HAS_CRAB, MobCategory.CREATURE, CRAB.get(), config.crabSpawnWeight, config.crabSpawnMinGroupSize, config.crabSpawnMaxGroupSize);
        }
        if (config.enableGlare && config.enableGlareSpawn) {
            event.add(FriendsAndFoesTags.HAS_GLARE, CustomSpawnGroup.getGlaresCategory(), GLARE.get(), config.glareSpawnWeight, config.glareSpawnMinGroupSize, config.glareSpawnMaxGroupSize);
        }
        if (config.enableMauler && config.enableMaulerSpawn) {
            event.add(FriendsAndFoesTags.HAS_BADLANDS_MAULER, MobCategory.CREATURE, MAULER.get(), config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            event.add(FriendsAndFoesTags.HAS_DESERT_MAULER, MobCategory.CREATURE, MAULER.get(), config.maulerDesertSpawnWeight, config.maulerDesertSpawnMinGroupSize, config.maulerDesertSpawnMaxGroupSize);
            event.add(FriendsAndFoesTags.HAS_SAVANNA_MAULER, MobCategory.CREATURE, MAULER.get(), config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
        }
        if (config.enableMoobloom && config.enableMoobloomSpawn) {
            event.add(FriendsAndFoesTags.HAS_MOOBLOOMS, MobCategory.CREATURE, MOOBLOOM.get(), config.moobloomSpawnWeight, config.moobloomSpawnMinGroupSize, config.moobloomSpawnMaxGroupSize);
        }
        if (config.enableRascal && config.enableRascalSpawn) {
            event.add(FriendsAndFoesTags.HAS_RASCAL, CustomSpawnGroup.getRascalsCategory(), RASCAL.get(), 4, 1, 1);
        }
    }

    private FriendsAndFoesEntityTypes() {
    }

    static {
        SharedConstants.CHECK_DATA_FIXER_SCHEMA = false;
        COPPER_GOLEM = ENTITY_TYPES.register("copper_golem", () -> EntityType.Builder.of(CopperGolemEntity::new, (MobCategory)MobCategory.MISC).sized(0.75f, 1.375f).clientTrackingRange(10).build(FriendsAndFoes.makeStringID("copper_golem")));
        CRAB = ENTITY_TYPES.register("crab", () -> EntityType.Builder.of(CrabEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.875f, 0.5625f).clientTrackingRange(10).build(FriendsAndFoes.makeStringID("crab")));
        GLARE = ENTITY_TYPES.register("glare", () -> EntityType.Builder.of(GlareEntity::new, (MobCategory)CustomSpawnGroup.getGlaresCategory()).sized(0.875f, 1.1875f).clientTrackingRange(8).updateInterval(2).build(FriendsAndFoes.makeStringID("glare")));
        ICEOLOGER = ENTITY_TYPES.register("iceologer", () -> EntityType.Builder.of(IceologerEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(10).build(FriendsAndFoes.makeStringID("iceologer")));
        ICE_CHUNK = ENTITY_TYPES.register("ice_chunk", () -> EntityType.Builder.of(IceologerIceChunkEntity::new, (MobCategory)MobCategory.MISC).fireImmune().sized(2.5f, 1.0f).clientTrackingRange(6).build(FriendsAndFoes.makeStringID("ice_chunk")));
        MAULER = ENTITY_TYPES.register("mauler", () -> EntityType.Builder.of(MaulerEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.5625f, 0.5625f).clientTrackingRange(10).build(FriendsAndFoes.makeStringID("mauler")));
        MOOBLOOM = ENTITY_TYPES.register("moobloom", () -> EntityType.Builder.of(MoobloomEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).clientTrackingRange(10).build(FriendsAndFoes.makeStringID("moobloom")));
        RASCAL = ENTITY_TYPES.register("rascal", () -> EntityType.Builder.of(RascalEntity::new, (MobCategory)CustomSpawnGroup.getRascalsCategory()).sized(0.9f, 1.25f).clientTrackingRange(10).build(FriendsAndFoes.makeStringID("rascal")));
        TUFF_GOLEM = ENTITY_TYPES.register("tuff_golem", () -> EntityType.Builder.of(TuffGolemEntity::new, (MobCategory)MobCategory.MISC).sized(0.75f, 1.0625f).clientTrackingRange(10).build(FriendsAndFoes.makeStringID("tuff_golem")));
        WILDFIRE = ENTITY_TYPES.register("wildfire", () -> EntityType.Builder.of(WildfireEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.12f, 3.0f).clientTrackingRange(10).fireImmune().build(FriendsAndFoes.makeStringID("wildfire")));
        PLAYER_ILLUSION = ENTITY_TYPES.register("player_illusion", () -> EntityType.Builder.of(PlayerIllusionEntity::new, (MobCategory)MobCategory.MISC).sized(0.7f, 1.875f).clientTrackingRange(10).fireImmune().build(FriendsAndFoes.makeStringID("player_illusion")));
        SharedConstants.CHECK_DATA_FIXER_SCHEMA = previousUseChoiceTypeRegistrations;
    }
}

