/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.init;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.util.StructurePoolHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public final class FriendsAndFoesStructurePoolElements {
    public static void init(MinecraftServer server) {
        Registry templatePoolRegistry = server.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        ResourceLocation plainsPoolLocation = new ResourceLocation("minecraft:village/plains/houses");
        ResourceLocation desertPoolLocation = new ResourceLocation("minecraft:village/desert/houses");
        ResourceLocation savannaPoolLocation = new ResourceLocation("minecraft:village/savanna/houses");
        ResourceLocation taigaPoolLocation = new ResourceLocation("minecraft:village/taiga/houses");
        ResourceLocation ancientCityCenterPoolLocation = new ResourceLocation("minecraft:ancient_city/city_center");
        if (FriendsAndFoes.getConfig().generateBeekeeperAreaStructure) {
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, plainsPoolLocation, "village/plains/houses/plains_beekeeper_area", FriendsAndFoes.getConfig().beekeeperAreaStructureWeight);
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, savannaPoolLocation, "village/savanna/houses/savanna_beekeeper_area", FriendsAndFoes.getConfig().beekeeperAreaStructureWeight);
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, taigaPoolLocation, "village/taiga/houses/taiga_beekeeper_area", FriendsAndFoes.getConfig().beekeeperAreaStructureWeight);
        }
        if (FriendsAndFoes.getConfig().generateCopperGolemAreaStructure) {
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, plainsPoolLocation, "village/plains/houses/plains_copper_golem_area", FriendsAndFoes.getConfig().copperGolemAreaStructureWeight);
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, desertPoolLocation, "village/desert/houses/desert_copper_golem_area", FriendsAndFoes.getConfig().copperGolemAreaStructureWeight);
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, savannaPoolLocation, "village/savanna/houses/savanna_copper_golem_area", FriendsAndFoes.getConfig().copperGolemAreaStructureWeight);
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, taigaPoolLocation, "village/taiga/houses/taiga_copper_golem_area", FriendsAndFoes.getConfig().copperGolemAreaStructureWeight);
        }
        if (FriendsAndFoes.getConfig().generateCopperGolemInAncientCity) {
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, ancientCityCenterPoolLocation, "ancient_city/city_center/city_center_1", FriendsAndFoes.getConfig().copperGolemAncientCityCenterWeight);
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, ancientCityCenterPoolLocation, "ancient_city/city_center/city_center_2", FriendsAndFoes.getConfig().copperGolemAncientCityCenterWeight);
            StructurePoolHelper.addElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, ancientCityCenterPoolLocation, "ancient_city/city_center/city_center_3", FriendsAndFoes.getConfig().copperGolemAncientCityCenterWeight);
        }
    }

    private FriendsAndFoesStructurePoolElements() {
    }
}

