/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatrolSpawner.class})
public final class PatrolSpawnerMixin {
    boolean friendsandfoes_isBiomeSpecificIllagerSpawned = false;

    @ModifyVariable(method={"spawnPatrolMember(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;Z)Z"}, ordinal=0, at=@At(value="LOAD"))
    private PatrollingMonster friendsandfoes_modifyPatrolEntity(PatrollingMonster patrolEntity, ServerLevel world, BlockPos pos, RandomSource random, boolean captain) {
        Holder biomeEntry = world.getBiome(pos);
        if (!this.friendsandfoes_isBiomeSpecificIllagerSpawned) {
            if (biomeEntry.is(FriendsAndFoesTags.HAS_ILLUSIONER)) {
                patrolEntity = (PatrollingMonster)EntityType.ILLUSIONER.create((Level)world);
            } else if (biomeEntry.is(FriendsAndFoesTags.HAS_ICEOLOGER)) {
                patrolEntity = (PatrollingMonster)FriendsAndFoesEntityTypes.ICEOLOGER.get().create((Level)world);
            }
        }
        return patrolEntity;
    }

    @Inject(method={"tick(Lnet/minecraft/server/level/ServerLevel;ZZ)I"}, at={@At(value="RETURN")})
    private void friendsandfoes_resetBiomeSpecificIllagerSpawnFlag(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals, CallbackInfoReturnable<Integer> callbackInfo) {
        Integer spawnerPatrolMembersCount = (Integer)callbackInfo.getReturnValue();
        if (spawnerPatrolMembersCount > 0) {
            this.friendsandfoes_isBiomeSpecificIllagerSpawned = false;
        }
    }
}

