/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.network.packet;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesParticleTypes;
import com.faboslav.friendsandfoes.common.network.MessageHandler;
import com.faboslav.friendsandfoes.common.network.base.Packet;
import com.faboslav.friendsandfoes.common.network.base.PacketContext;
import com.faboslav.friendsandfoes.common.network.base.PacketHandler;
import com.faboslav.friendsandfoes.common.util.TotemUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record TotemEffectPacket(ItemStack itemStack, int entityId) implements Packet<TotemEffectPacket>
{
    public static Gson gson = new GsonBuilder().create();
    public static final ResourceLocation ID = FriendsAndFoes.makeID("totem_effect_packet");
    public static final Handler HANDLER = new Handler();

    public static void sendToClient(Player player, ItemStack itemStack) {
        TotemEffectPacket totemEffectPacket = new TotemEffectPacket(itemStack, player.getId());
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(totemEffectPacket, player);
        MessageHandler.DEFAULT_CHANNEL.sendToAllLoaded(totemEffectPacket, player.level(), player.blockPosition());
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PacketHandler<TotemEffectPacket> getHandler() {
        return HANDLER;
    }

    public static class Handler
    implements PacketHandler<TotemEffectPacket> {
        @Override
        public PacketContext handle(TotemEffectPacket packet) {
            return (player, level) -> {
                Entity entity = level.getEntity(packet.entityId());
                if (entity == null || player.getId() != entity.getId()) {
                    return;
                }
                if (packet.itemStack.getItem() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                    TotemUtil.playActivateAnimation(packet.itemStack, entity, (ParticleType)FriendsAndFoesParticleTypes.TOTEM_OF_FREEZING.get());
                } else if (packet.itemStack.getItem() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                    TotemUtil.playActivateAnimation(packet.itemStack, entity, (ParticleType)FriendsAndFoesParticleTypes.TOTEM_OF_FREEZING.get());
                }
            };
        }

        @Override
        public TotemEffectPacket decode(FriendlyByteBuf buf) {
            return new TotemEffectPacket(buf.readItem(), buf.readInt());
        }

        @Override
        public void encode(TotemEffectPacket packet, FriendlyByteBuf buf) {
            buf.writeItem(packet.itemStack);
            buf.writeInt(packet.entityId);
        }
    }
}

