/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.platform.neoforge;

import com.faboslav.friendsandfoes.common.network.base.Packet;
import com.faboslav.friendsandfoes.common.network.base.PacketHandler;
import com.faboslav.friendsandfoes.common.platform.ModVersion;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.NetworkRegistry;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.simple.SimpleChannel;

public class PacketChannelManagerImpl {
    public static final Map<ResourceLocation, Channel> CHANNELS = new HashMap<ResourceLocation, Channel>();

    public static void registerChannel(ResourceLocation name) {
        String protocolVersion = ModVersion.getModVersion();
        Channel channel = new Channel(0, NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> protocolVersion, protocolVersion::equals, protocolVersion::equals));
        CHANNELS.put(name, channel);
    }

    public static <T extends Packet<T>> void registerS2CPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        ++channel.packets;
        channel.channel.registerMessage(channel.packets, packetClass, handler::encode, handler::decode, (msg, ctx) -> {
            ctx.enqueueWork(() -> {
                Player player;
                Object object = player = ctx.getSender() == null ? PacketChannelManagerImpl.getPlayer() : null;
                if (player != null) {
                    ctx.enqueueWork(() -> handler.handle(msg).apply(player, player.level()));
                }
            });
            ctx.setPacketHandled(true);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Player getPlayer() {
        return Minecraft.getInstance().player;
    }

    public static <T extends Packet<T>> void registerC2SPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        ++channel.packets;
        channel.channel.registerMessage(channel.packets, packetClass, handler::encode, handler::decode, (msg, ctx) -> {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                ctx.enqueueWork(() -> PacketChannelManagerImpl.lambda$registerC2SPacket$4(handler, msg, (Player)player));
            }
            ctx.setPacketHandled(true);
        });
    }

    public static <T extends Packet<T>> void sendToServer(ResourceLocation name, T packet) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        channel.channel.sendToServer(packet);
    }

    public static <T extends Packet<T>> void sendToPlayer(ResourceLocation name, T packet, Player player) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            channel.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        }
    }

    private static /* synthetic */ void lambda$registerC2SPacket$4(PacketHandler handler, Packet msg, Player player) {
        handler.handle(msg).apply(player, player.level());
    }

    private static final class Channel {
        private int packets;
        private final SimpleChannel channel;

        private Channel(int packets, SimpleChannel channel) {
            this.packets = packets;
            this.channel = channel;
        }
    }
}

