/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.neoforge;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.events.AddItemGroupEntriesEvent;
import com.faboslav.friendsandfoes.common.events.RegisterVillagerTradesEvent;
import com.faboslav.friendsandfoes.common.events.block.RegisterBlockSetTypeEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntityAttributesEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntitySpawnRestrictionsEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterFlammabilityEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterReloadListenerEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.SetupEvent;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesStructurePoolElements;
import com.faboslav.friendsandfoes.common.util.CustomRaidMember;
import com.faboslav.friendsandfoes.common.util.ServerWorldSpawnersUtil;
import com.faboslav.friendsandfoes.common.world.spawner.IceologerSpawner;
import com.faboslav.friendsandfoes.common.world.spawner.IllusionerSpawner;
import com.faboslav.friendsandfoes.neoforge.FriendsAndFoesNeoForgeClient;
import com.faboslav.friendsandfoes.neoforge.init.FriendsAndFoesBiomeModifiers;
import com.faboslav.friendsandfoes.neoforge.mixin.FireBlockAccessor;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@Mod(value="friendsandfoes")
public final class FriendsAndFoesNeoForge {
    public FriendsAndFoesNeoForge(IEventBus modEventBus) {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        FriendsAndFoes.init();
        FriendsAndFoesBiomeModifiers.BIOME_MODIFIERS.register(modEventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FriendsAndFoesNeoForgeClient.init(modEventBus, eventBus);
        }
        eventBus.addListener(FriendsAndFoesNeoForge::initSpawners);
        eventBus.addListener(FriendsAndFoesNeoForge::onServerAboutToStartEvent);
        eventBus.addListener(FriendsAndFoesNeoForge::onAddVillagerTrades);
        eventBus.addListener(FriendsAndFoesNeoForge::onAddReloadListeners);
        eventBus.addListener(FriendsAndFoesNeoForge::onDatapackSync);
        modEventBus.addListener(FriendsAndFoesNeoForge::onSetup);
        modEventBus.addListener(FriendsAndFoesNeoForge::onRegisterAttributes);
        modEventBus.addListener(FriendsAndFoesNeoForge::onRegisterSpawnRestrictions);
        modEventBus.addListener(FriendsAndFoesNeoForge::onAddItemGroupEntries);
    }

    private static void onSetup(FMLCommonSetupEvent event) {
        SetupEvent.EVENT.invoke(new SetupEvent(arg_0 -> ((FMLCommonSetupEvent)event).enqueueWork(arg_0)));
        event.enqueueWork(() -> {
            FriendsAndFoes.lateInit();
            if (FriendsAndFoes.getConfig().enableIceologer && FriendsAndFoes.getConfig().enableIceologerInRaids) {
                Raid.RaiderType.create((String)"ICEOLOGER", FriendsAndFoesEntityTypes.ICEOLOGER.get(), (int[])CustomRaidMember.ICEOLOGER_COUNT_IN_WAVE);
            }
            if (FriendsAndFoes.getConfig().enableIllusioner && FriendsAndFoes.getConfig().enableIllusionerInRaids) {
                Raid.RaiderType.create((String)"ILLUSIONER", (EntityType)EntityType.ILLUSIONER, (int[])CustomRaidMember.ILLUSIONER_COUNT_IN_WAVE);
            }
            RegisterBlockSetTypeEvent.EVENT.invoke(new RegisterBlockSetTypeEvent(BlockSetType::register));
            RegisterFlammabilityEvent.EVENT.invoke(new RegisterFlammabilityEvent((item, igniteOdds, burnOdds) -> ((FireBlockAccessor)Blocks.FIRE).invokeRegisterFlammableBlock(item, igniteOdds, burnOdds)));
        });
    }

    private static void onAddReloadListeners(AddReloadListenerEvent event) {
        RegisterReloadListenerEvent.EVENT.invoke(new RegisterReloadListenerEvent((id, listener) -> event.addListener(listener)));
    }

    private static void onDatapackSync(OnDatapackSyncEvent event) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            if (event.getPlayer() != null) {
                DatapackSyncEvent.EVENT.invoke(new DatapackSyncEvent(event.getPlayer()));
            } else {
                event.getPlayerList().getPlayers().forEach(player -> DatapackSyncEvent.EVENT.invoke(new DatapackSyncEvent((ServerPlayer)player)));
            }
        }
    }

    private static void onAddVillagerTrades(VillagerTradesEvent event) {
        RegisterVillagerTradesEvent.EVENT.invoke(new RegisterVillagerTradesEvent(event.getType(), (i, listing) -> ((List)event.getTrades().get(i.intValue())).add(listing)));
    }

    private static void onAddItemGroupEntries(BuildCreativeModeTabContentsEvent event) {
        AddItemGroupEntriesEvent.EVENT.invoke(new AddItemGroupEntriesEvent(AddItemGroupEntriesEvent.Type.toType((ResourceKey<CreativeModeTab>)((ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)event.getTab()).orElse(null))), event.getTab(), event.hasPermissions(), arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0)));
    }

    private static void onRegisterAttributes(EntityAttributeCreationEvent event) {
        RegisterEntityAttributesEvent.EVENT.invoke(new RegisterEntityAttributesEvent((entity, builder) -> event.put(entity, builder.build())));
    }

    private static void onRegisterSpawnRestrictions(SpawnPlacementRegisterEvent event) {
        RegisterEntitySpawnRestrictionsEvent.EVENT.invoke(new RegisterEntitySpawnRestrictionsEvent(FriendsAndFoesNeoForge.registerEntitySpawnRestriction(event)));
    }

    private static RegisterEntitySpawnRestrictionsEvent.Registrar registerEntitySpawnRestriction(final SpawnPlacementRegisterEvent event) {
        return new RegisterEntitySpawnRestrictionsEvent.Registrar(){

            @Override
            public <T extends Mob> void register(EntityType<T> type, RegisterEntitySpawnRestrictionsEvent.Placement<T> placement) {
                event.register(type, placement.location(), placement.heightmap(), placement.predicate(), SpawnPlacementRegisterEvent.Operation.AND);
            }
        };
    }

    private static void initSpawners(LevelEvent.Load event) {
        if (event.getLevel().isClientSide() || ((ServerLevel)event.getLevel()).dimensionTypeId() != BuiltinDimensionTypes.OVERWORLD) {
            return;
        }
        MinecraftServer server = event.getLevel().getServer();
        if (server == null) {
            return;
        }
        ServerLevel world = server.overworld();
        if (world == null) {
            return;
        }
        ServerWorldSpawnersUtil.register(world, new IceologerSpawner());
        ServerWorldSpawnersUtil.register(world, new IllusionerSpawner());
    }

    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        FriendsAndFoesStructurePoolElements.init(event.getServer());
    }
}

