/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.block.CrabEggBlock;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.CrabAnimations;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CrabBrain;
import com.faboslav.friendsandfoes.common.entity.ai.control.WallClimbNavigation;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.CrabEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CrabEntity
extends Animal
implements FlyingAnimal,
AnimatedEntity {
    private static final float MOVEMENT_SPEED = 0.225f;
    private static final String SIZE_NBT_NAME = "Size";
    private static final String HOME_NBT_NAME = "Home";
    private static final String HOME_NBT_NAME_X = "x";
    private static final String HOME_NBT_NAME_Y = "y";
    private static final String HOME_NBT_NAME_Z = "z";
    private static final String HAS_EGG_NBT_NAME = "HasEgg";
    private AnimationContextTracker animationContextTracker;
    private static final EntityDataAccessor<Integer> POSE_TICKS = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_CLIMBING_WALL = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> SIZE = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<CompoundTag> HOME = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DANCING = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int climbingTicks = 0;

    public CrabEntity(EntityType<? extends CrabEntity> entityType, Level world) {
        super(entityType, world);
        this.setPose(CrabEntityPose.IDLE);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_OPEN, -1.0f);
        this.m_274367_(0.0f);
        this.f_21365_ = new CrabLookControl(this, 10);
        this.f_21344_ = new CrabWallClimbNavigation((Mob)this, world);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData superEntityData = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        this.setHome(this.getNewHome());
        this.setSize(CrabSize.getRandomCrabSize(world.m_213780_()));
        this.setPose(CrabEntityPose.IDLE);
        CrabBrain.setWaveCooldown(this);
        return superEntityData;
    }

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
                this.animationContextTracker.add(keyframeAnimation);
            }
            this.animationContextTracker.add(this.getMovementAnimation());
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return CrabAnimations.ANIMATIONS;
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        return CrabAnimations.WALK;
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public boolean m_147223_() {
        return this.m_6069_();
    }

    protected void m_6135_() {
    }

    public boolean m_29443_() {
        return this.m_6147_();
    }

    public float m_6113_() {
        if (this.m_6162_()) {
            return 0.1125f;
        }
        return 0.225f;
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return (Integer)this.f_19804_.m_135370_(POSE_TICKS);
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.f_19804_.m_135381_(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POSE_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_CLIMBING_WALL, (Object)false);
        this.f_19804_.m_135372_(SIZE, (Object)CrabSize.getDefaultCrabSize().getName());
        this.f_19804_.m_135372_(HOME, (Object)new CompoundTag());
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(IS_DANCING, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_(SIZE_NBT_NAME, this.getSize().getName());
        nbt.m_128365_(HOME_NBT_NAME, (Tag)this.getHome());
        nbt.m_128379_(HAS_EGG_NBT_NAME, this.hasEgg());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        CrabSize crabSize = CrabSize.getCrabSizeByName(nbt.m_128461_(SIZE_NBT_NAME));
        if (crabSize == null) {
            crabSize = CrabSize.getDefaultCrabSize();
        }
        this.setSize(crabSize);
        this.setHome(nbt.m_128469_(HOME_NBT_NAME));
        this.setHasEgg(nbt.m_128471_(HAS_EGG_NBT_NAME));
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return CrabBrain.create(dynamic);
    }

    public Brain<CrabEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public static AttributeSupplier.Builder createCrabAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, (double)0.225f).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.175f;
    }

    public boolean m_6147_() {
        return this.climbingTicks > 8 && this.isClimbingWall();
    }

    public boolean isClimbingWall() {
        return (Boolean)this.f_19804_.m_135370_(IS_CLIMBING_WALL);
    }

    public void setClimbingWall(boolean isClimbingWall) {
        this.f_19804_.m_135381_(IS_CLIMBING_WALL, (Object)isClimbingWall);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_CRAB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return FriendsAndFoesSoundEvents.ENTITY_CRAB_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.m_20096_() && state.m_278721_()) {
            return;
        }
        this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_CRAB_STEP.get(), 0.15f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_() && !FriendsAndFoes.getConfig().enableCrab) {
            this.m_146870_();
        }
        this.updateKeyframeAnimations();
        this.calculateSize();
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.setClimbingWall(this.f_19862_);
        }
        if (this.isClimbingWall()) {
            ++this.climbingTicks;
            BlockState blockStateAtPos = this.m_146900_();
            if (this.isMoving() && !blockStateAtPos.m_278721_() && this.climbingTicks % 6 == 0) {
                this.m_7355_(this.m_20183_(), blockStateAtPos);
            }
        } else {
            this.climbingTicks = 0;
        }
        if (this.m_6147_()) {
            Vec3 velocity = this.m_20184_();
            this.m_20334_(velocity.f_82479_, velocity.f_82480_ * (double)0.33f, velocity.f_82481_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 5 == 0) {
            boolean isDancing = false;
            for (BlockPos blockPos : BlockPos.m_121925_((BlockPos)this.m_20183_(), (int)7, (int)7, (int)7)) {
                BlockEntity possibleJukeboxBlockEntity;
                BlockPos.MutableBlockPos possibleJukeboxBlockPos = blockPos.m_122032_();
                BlockState possibleJukeboxBlockState = this.m_9236_().m_8055_((BlockPos)possibleJukeboxBlockPos);
                if (!possibleJukeboxBlockState.m_60713_(Blocks.f_50131_) || !possibleJukeboxBlockState.m_155947_() || !((possibleJukeboxBlockEntity = this.m_9236_().m_7702_((BlockPos)possibleJukeboxBlockPos)) instanceof JukeboxBlockEntity) || !((JukeboxBlockEntity)possibleJukeboxBlockEntity).m_272025_()) continue;
                isDancing = true;
                break;
            }
            this.setIsDancing(isDancing);
        }
    }

    private void updateKeyframeAnimations() {
        KeyframeAnimation keyframeAnimationToStart;
        if (!this.m_9236_().m_5776_()) {
            this.updateKeyframeAnimationTicks();
        }
        if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null) {
            this.tryToStartKeyframeAnimation(keyframeAnimationToStart);
        }
    }

    @Nullable
    private KeyframeAnimation getKeyframeAnimationByPose() {
        KeyframeAnimation keyframeAnimation = null;
        if (this.isInPose(CrabEntityPose.IDLE) && !this.isMoving()) {
            keyframeAnimation = CrabAnimations.IDLE;
        } else if (this.isInPose(CrabEntityPose.WAVE)) {
            keyframeAnimation = CrabAnimations.WAVE;
        } else if (this.isInPose(CrabEntityPose.DANCE)) {
            keyframeAnimation = CrabAnimations.DANCE;
        }
        return keyframeAnimation;
    }

    private void tryToStartKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        if (this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
        }
        this.startKeyframeAnimation(keyframeAnimationToStart);
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        this.startKeyframeAnimation(keyframeAnimationToStart, this.f_19797_);
    }

    public void startWaveAnimation() {
        if (this.isInPose(CrabEntityPose.WAVE)) {
            return;
        }
        this.setPose(CrabEntityPose.WAVE);
    }

    public void startDanceAnimation() {
        if (this.isInPose(CrabEntityPose.DANCE)) {
            return;
        }
        this.setPose(CrabEntityPose.DANCE);
    }

    public void setPose(CrabEntityPose pose) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.m_20124_(pose.get());
    }

    public boolean m_217003_(Pose pose) {
        return this.m_20089_() == pose;
    }

    public boolean isInPose(CrabEntityPose pose) {
        return this.m_20089_() == pose.get();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("crabBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("crabMemoryUpdate");
        CrabBrain.updateMemories(this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("crabActivityUpdate");
        CrabBrain.updateActivities(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)FriendsAndFoesItems.CRAB_CLAW.get(), 1);
        }
    }

    public boolean isMoving() {
        return (this.m_20096_() || this.m_6147_()) && this.m_20184_().m_82556_() >= 1.0E-4;
    }

    public static boolean canSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(FriendsAndFoesTags.CRABS_SPAWNABLE_ON) && CrabEggBlock.isSuitableBelow((BlockGetter)world, pos) && CrabEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return CrabBrain.getTemptItems().test(itemStack);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob entity) {
        CrabEntity crab = (CrabEntity)FriendsAndFoesEntityTypes.CRAB.get().m_20615_((Level)serverWorld);
        CrabBrain.setWaveCooldown(crab);
        return crab;
    }

    public void m_27563_(ServerLevel world, Animal mate) {
        ServerPlayer serverPlayerEntity = this.m_27592_();
        if (serverPlayerEntity == null && mate.m_27592_() != null) {
            serverPlayerEntity = mate.m_27592_();
        }
        if (serverPlayerEntity != null) {
            serverPlayerEntity.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(serverPlayerEntity, (Animal)this, mate, null);
        }
        this.setHasEgg(true);
        this.m_27594_();
        mate.m_27594_();
        RandomSource random = this.m_217043_();
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), random.m_188503_(7) + 1));
        }
    }

    @Nullable
    public GlobalPos getBurrowSpotPos() {
        return this.m_6274_().m_257414_(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get()).orElse(null);
    }

    public boolean isBurrowSpotAccessible(BlockPos pos) {
        Level world = this.m_9236_();
        boolean isBlockSand = world.m_8055_(pos.m_7495_()).m_204336_(FriendsAndFoesTags.CRAB_BURROW_SPOT_BLOCKS);
        boolean isBlockAccessible = world.m_46859_(pos) && world.m_46859_(pos.m_7494_());
        return isBlockSand && isBlockAccessible;
    }

    public CompoundTag getNewHome() {
        CompoundTag home = new CompoundTag();
        home.m_128347_(HOME_NBT_NAME_X, this.m_20182_().m_7096_());
        home.m_128347_(HOME_NBT_NAME_Y, this.m_20182_().m_7098_());
        home.m_128347_(HOME_NBT_NAME_Z, this.m_20182_().m_7094_());
        return home;
    }

    public void setHome(CompoundTag home) {
        this.f_19804_.m_135381_(HOME, (Object)home);
    }

    public CompoundTag getHome() {
        return (CompoundTag)this.f_19804_.m_135370_(HOME);
    }

    public Vec3 getHomePos() {
        return new Vec3(this.getHome().m_128459_(HOME_NBT_NAME_X), this.getHome().m_128459_(HOME_NBT_NAME_Y), this.getHome().m_128459_(HOME_NBT_NAME_Z));
    }

    public boolean isAtHomePos() {
        return this.m_20238_(this.getHomePos()) < 0.1;
    }

    public boolean isCloseToHomePos(float distance) {
        return this.m_20238_(this.getHomePos()) < (double)distance;
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(IS_DANCING);
    }

    public void setIsDancing(boolean isDancing) {
        this.f_19804_.m_135381_(IS_DANCING, (Object)isDancing);
    }

    private void setSize(CrabSize size) {
        this.f_19804_.m_135381_(SIZE, (Object)size.getName());
        this.calculateSize();
    }

    private void calculateSize() {
        this.m_6210_();
        this.m_142242_();
    }

    public CrabSize getSize() {
        return CrabSize.getCrabSizeByName((String)this.f_19804_.m_135370_(SIZE));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getSize().scaleModifier);
    }

    class CrabLookControl
    extends SmoothSwimmingLookControl {
        public CrabLookControl(CrabEntity crab, int yawAdjustThreshold) {
            super((Mob)crab, yawAdjustThreshold);
        }

        public void m_8128_() {
            if (!CrabEntity.this.m_6147_()) {
                super.m_8128_();
            }
        }
    }

    class CrabWallClimbNavigation
    extends WallClimbNavigation {
        public CrabWallClimbNavigation(Mob mobEntity, Level world) {
            super(mobEntity, world);
        }

        @Override
        public void m_7638_() {
            if (!CrabEntity.this.isDancing()) {
                super.m_7638_();
            }
        }
    }

    public static enum CrabSize {
        SMALL("small", 0.9f),
        MEDIUM("medium", 0.95f),
        BIG("big", 1.0f);

        private final String name;
        private final float scaleModifier;

        private CrabSize(String name, float scaleModifier) {
            this.name = name;
            this.scaleModifier = scaleModifier;
        }

        public String getName() {
            return this.name;
        }

        public float getScaleModifier() {
            return this.scaleModifier;
        }

        @Nullable
        public static CrabSize getCrabSizeByName(String name) {
            for (CrabSize crabSize : CrabSize.values()) {
                if (!Objects.equals(crabSize.getName(), name)) continue;
                return crabSize;
            }
            return null;
        }

        public static CrabSize getDefaultCrabSize() {
            return BIG;
        }

        public static CrabSize getRandomCrabSize(RandomSource random) {
            CrabSize[] values = CrabSize.values();
            int min = 0;
            int max = values.length - 1;
            return values[random.m_188503_(max - min + 1) + min];
        }
    }
}

