/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.CopperGolemAnimations;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.KeyframeAnimationContext;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.CopperGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.mixin.LimbAnimatorAccessor;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class CopperGolemEntity
extends AbstractGolem
implements AnimatedEntity {
    private AnimationContextTracker animationContextTracker;
    private static final EntityDataAccessor<Integer> POSE_TICKS = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final float MOVEMENT_SPEED = 0.2f;
    private static final int COPPER_INGOT_HEAL_AMOUNT = 5;
    private static final float SPARK_CHANCE = 0.025f;
    private static final float OXIDATION_CHANCE = 2.0E-5f;
    public static final int MIN_STRUCT_BY_LIGHTNING_TICKS = 1200;
    public static final int MAX_STRUCT_BY_LIGHTNING_TICKS = 2400;
    private static final String POSE_NBT_NAME = "Pose";
    private static final String POSE_TICKS_NBT_NAME = "PoseTicks";
    private static final String OXIDATION_LEVEL_NBT_NAME = "OxidationLevel";
    private static final String IS_WAXED_NBT_NAME = "IsWaxed";
    private static final String ENTITY_SNAPSHOT_NBT_NAME = "EntitySnapshot";
    private static final EntityDataAccessor<Integer> OXIDATION_LEVEL = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STRUCT_BY_LIGHTNING_TICKS = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WAS_STATUE = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_WAXED = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<CompoundTag> ENTITY_SNAPSHOT = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.refreshAnimationContextTracker();
        }
        return this.animationContextTracker;
    }

    private void refreshAnimationContextTracker() {
        this.animationContextTracker = new AnimationContextTracker();
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            this.animationContextTracker.add(keyframeAnimation);
        }
        this.animationContextTracker.add(this.getMovementAnimation());
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return CopperGolemAnimations.getAnimations(this.getAnimationSpeedModifier());
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        return CopperGolemAnimations.getWalkKeyframeAnimation(this.getAnimationSpeedModifier());
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return (Integer)this.f_19804_.m_135370_(POSE_TICKS);
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.f_19804_.m_135381_(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    public CopperGolemEntity(EntityType<? extends CopperGolemEntity> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new CopperGolemMoveControl(this);
        this.f_21365_ = new CopperGolemLookControl(this);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData superEntityData = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        if (spawnReason == MobSpawnType.STRUCTURE) {
            return superEntityData;
        }
        this.setPose(CopperGolemEntityPose.IDLE);
        CopperGolemBrain.setSpinHeadCooldown(this);
        CopperGolemBrain.setPressButtonCooldown(this);
        return superEntityData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POSE_TICKS, (Object)0);
        this.f_19804_.m_135372_(OXIDATION_LEVEL, (Object)WeatheringCopper.WeatherState.UNAFFECTED.ordinal());
        this.f_19804_.m_135372_(STRUCT_BY_LIGHTNING_TICKS, (Object)0);
        this.f_19804_.m_135372_(WAS_STATUE, (Object)false);
        this.f_19804_.m_135372_(IS_WAXED, (Object)false);
        this.f_19804_.m_135372_(ENTITY_SNAPSHOT, (Object)new CompoundTag());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_(OXIDATION_LEVEL_NBT_NAME, this.getOxidationLevel().ordinal());
        nbt.m_128379_(IS_WAXED_NBT_NAME, this.isWaxed());
        if (this.isOxidized()) {
            nbt.m_128359_(POSE_NBT_NAME, this.m_20089_().name());
            nbt.m_128405_(POSE_TICKS_NBT_NAME, this.getKeyframeAnimationTicks());
            nbt.m_128365_(ENTITY_SNAPSHOT_NBT_NAME, (Tag)this.getEntitySnapshot());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_(POSE_NBT_NAME)) {
            Pose entityPose = Pose.valueOf((String)nbt.m_128461_(POSE_NBT_NAME));
            this.m_20124_(entityPose);
        }
        if (nbt.m_128441_(POSE_TICKS_NBT_NAME)) {
            this.setKeyframeAnimationTicks(nbt.m_128451_(POSE_TICKS_NBT_NAME));
        }
        if (nbt.m_128441_(OXIDATION_LEVEL_NBT_NAME)) {
            this.setOxidationLevel(WeatheringCopper.WeatherState.values()[nbt.m_128451_(OXIDATION_LEVEL_NBT_NAME)]);
        }
        if (nbt.m_128441_(IS_WAXED_NBT_NAME)) {
            this.setIsWaxed(nbt.m_128471_(IS_WAXED_NBT_NAME));
        }
        if (nbt.m_128441_(ENTITY_SNAPSHOT_NBT_NAME)) {
            this.setEntitySnapshot(nbt.m_128469_(ENTITY_SNAPSHOT_NBT_NAME));
            this.applyEntitySnapshot();
        }
    }

    public static AttributeSupplier.Builder createCopperGolemAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return CopperGolemBrain.create(dynamic);
    }

    public Brain<CopperGolemEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public void setEntitySnapshot(CompoundTag entitySnapshot) {
        this.f_19804_.m_135381_(ENTITY_SNAPSHOT, (Object)entitySnapshot);
    }

    public void applyEntitySnapshot() {
        CompoundTag entitySnapshot = this.getEntitySnapshot();
        if (entitySnapshot.m_128456_()) {
            return;
        }
        if (!this.m_20159_()) {
            this.f_20907_ = entitySnapshot.m_128459_("serverYaw");
            this.f_19859_ = entitySnapshot.m_128457_("prevYaw");
            this.m_146922_(this.f_19859_);
            this.f_20883_ = this.f_20884_ = entitySnapshot.m_128457_("prevBodyYaw");
            this.f_20933_ = entitySnapshot.m_128459_("serverHeadYaw");
            this.f_20885_ = this.f_20886_ = entitySnapshot.m_128457_("prevHeadYaw");
            this.f_20894_ = this.f_20895_ = entitySnapshot.m_128457_("prevLookDirection");
        }
        this.f_19860_ = entitySnapshot.m_128457_("prevPitch");
        this.f_20908_ = this.f_19860_;
        this.m_146926_(this.f_19860_);
        this.f_20937_ = entitySnapshot.m_128451_("roll");
        this.f_20921_ = this.f_20920_ = entitySnapshot.m_128457_("lastHandSwingProgress");
        ((LimbAnimatorAccessor)this.f_267362_).setPrevSpeed(entitySnapshot.m_128457_("limbAnimatorPrevSpeed"));
        this.f_267362_.m_267771_(entitySnapshot.m_128457_("limbAnimatorSpeed"));
        ((LimbAnimatorAccessor)this.f_267362_).setPos(entitySnapshot.m_128457_("limbAnimatorPos"));
        this.f_20893_ = this.f_20892_ = entitySnapshot.m_128457_("prevStepBobbingAmount");
    }

    public CompoundTag getEntitySnapshot() {
        return (CompoundTag)this.f_19804_.m_135370_(ENTITY_SNAPSHOT);
    }

    private CompoundTag takeEntitySnapshot() {
        CompoundTag entitySnapshot = new CompoundTag();
        entitySnapshot.m_128347_("serverYaw", this.f_20907_);
        entitySnapshot.m_128350_("prevYaw", this.f_19859_);
        entitySnapshot.m_128347_("serverPitch", this.f_20908_);
        entitySnapshot.m_128350_("prevPitch", this.f_19860_);
        entitySnapshot.m_128405_("roll", this.m_21256_());
        entitySnapshot.m_128350_("prevBodyYaw", this.f_20884_);
        entitySnapshot.m_128347_("serverHeadYaw", this.f_20933_);
        entitySnapshot.m_128350_("prevHeadYaw", this.f_20886_);
        entitySnapshot.m_128350_("lastHandSwingProgress", this.f_20920_);
        entitySnapshot.m_128350_("limbAnimatorPrevSpeed", ((LimbAnimatorAccessor)this.f_267362_).getPresSpeed());
        entitySnapshot.m_128350_("limbAnimatorSpeed", this.f_267362_.m_267731_());
        entitySnapshot.m_128350_("limbAnimatorPos", this.f_267362_.m_267756_());
        entitySnapshot.m_128350_("prevLookDirection", this.f_20895_);
        entitySnapshot.m_128350_("prevStepBobbingAmount", this.f_20892_);
        return entitySnapshot;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public float m_6100_() {
        return (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 2.5f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.isImmobilized() || state.m_60767_().m_76332_()) {
            return;
        }
        BlockState blockState = this.m_9236_().m_8055_(pos.m_7494_());
        SoundType blockSoundGroup = blockState.m_204336_(BlockTags.f_144271_) ? blockState.m_60827_() : state.m_60827_();
        this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_STEP.get(), blockSoundGroup.m_56773_() * 0.15f, this.m_6100_());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        if (attacker instanceof LightningBolt || source == this.m_269291_().m_269555_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.45, 0.0);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.75f;
    }

    public float getMovementSpeedModifier() {
        if (this.isStructByLightning()) {
            return 1.5f;
        }
        return (0.2f - (float)this.getOxidationModifier() * 0.033333335f) / 0.2f;
    }

    public float getAnimationSpeedModifier() {
        if (this.isStructByLightning()) {
            return 0.6666666f;
        }
        return 0.2f / (0.2f - (float)this.getOxidationModifier() * 0.033333335f);
    }

    private int getOxidationModifier() {
        return Math.min(this.getOxidationLevel().ordinal(), WeatheringCopper.WeatherState.WEATHERED.ordinal());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item itemInHand = itemStack.m_41720_();
        boolean interactionResult = false;
        if (itemInHand == Items.f_151052_) {
            interactionResult = this.tryToInteractMobWithCopperIngot(player, itemStack);
        } else if (itemInHand == Items.f_42784_) {
            interactionResult = this.tryToInteractMobWithHoneycomb(player, itemStack);
        } else if (itemInHand instanceof AxeItem) {
            interactionResult = this.tryToInteractMobWithAxe(player, hand, itemStack);
        }
        if (interactionResult) {
            this.m_146852_(GameEvent.f_223708_, (Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    private boolean tryToInteractMobWithCopperIngot(Player player, ItemStack itemStack) {
        if (this.m_21223_() == this.m_21233_()) {
            return false;
        }
        this.m_5634_(5.0f);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_REPAIR.get(), 1.0f, this.m_6100_() - 1.0f);
        return true;
    }

    private boolean tryToInteractMobWithHoneycomb(Player player, ItemStack itemStack) {
        if (this.isWaxed() || this.isImmobilized()) {
            return false;
        }
        this.setIsWaxed(true);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.m_5496_(SoundEvents.f_144178_, 1.0f, 1.0f);
        ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.f_175828_, 7, 1.0);
        return true;
    }

    private boolean tryToInteractMobWithAxe(Player player, InteractionHand hand, ItemStack itemStack) {
        if (!this.isWaxed() && !this.isDegraded() || this.wasStatue() && !this.isOxidized()) {
            return false;
        }
        if (this.isWaxed()) {
            this.setIsWaxed(false);
            this.m_5496_(SoundEvents.f_144060_, 1.0f, 1.0f);
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.f_175829_, 7, 1.0);
        } else if (this.isDegraded()) {
            if (!this.m_9236_().m_5776_()) {
                int increasedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() - 1;
                WeatheringCopper.WeatherState[] OxidationLevels = WeatheringCopper.WeatherState.values();
                this.setOxidationLevel(OxidationLevels[increasedOxidationLevelOrdinal]);
            }
            this.m_5496_(SoundEvents.f_144059_, 1.0f, 1.0f);
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.f_175831_, 7, 1.0);
        }
        if (!this.m_9236_().m_5776_() && !player.m_150110_().f_35937_) {
            itemStack.m_41622_(1, (LivingEntity)player, playerEntity -> player.m_21190_(hand));
        }
        return true;
    }

    protected void m_8024_() {
        if (this.isImmobilized()) {
            super.m_8024_();
            return;
        }
        this.m_9236_().m_46473_().m_6180_("copperGolemBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("copperGolemActivityUpdate");
        CopperGolemBrain.updateActivities(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_8119_() {
        if (!FriendsAndFoes.getConfig().enableCopperGolem) {
            this.m_146870_();
        }
        this.updateKeyframeAnimations();
        super.m_8119_();
        if (this.isOxidized()) {
            this.applyEntitySnapshot();
            MovementUtil.stopMovement((Mob)this);
            return;
        }
        if (this.isStructByLightning() && !this.m_20193_().m_5776_()) {
            this.setStructByLightningTicks(this.getStructByLightningTicks() - 1);
            if (this.m_217043_().m_188501_() < 0.025f) {
                for (int i = 0; i < 7; ++i) {
                    ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_175830_, this.m_20208_(0.35), this.m_20187_() + 0.25, this.m_20262_(0.35), 1, this.m_217043_().m_188583_() * 0.01, this.m_217043_().m_188583_() * 0.01, this.m_217043_().m_188583_() * 0.01, 0.1);
                }
            }
        }
        this.handleOxidationIncrease();
    }

    public boolean m_6094_() {
        return !this.isImmobilized();
    }

    public void m_8038_(ServerLevel serverWorld, LightningBolt lightning) {
        super.m_8038_(serverWorld, lightning);
        this.m_7311_(0);
        this.m_146868_(false);
        this.m_21153_(this.m_21233_());
        if (this.isDegraded()) {
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.f_175829_, 7, 1.0);
        }
        if (!this.m_20193_().m_5776_()) {
            this.refreshStructByLightningTicks();
            if (!this.isWaxed()) {
                this.setOxidationLevel(WeatheringCopper.WeatherState.UNAFFECTED);
            }
        }
    }

    private void updateKeyframeAnimations() {
        KeyframeAnimation keyframeAnimationToStart;
        if (!this.m_9236_().m_5776_() && !this.isOxidized()) {
            this.updateKeyframeAnimationTicks();
        }
        if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null) {
            this.tryToStartKeyframeAnimation(keyframeAnimationToStart);
        }
    }

    @Override
    public void updateKeyframeAnimationTicks() {
        if (!this.isAnyKeyframeAnimationRunning()) {
            return;
        }
        this.setKeyframeAnimationTicks(this.getKeyframeAnimationTicks() - 1);
        if (!this.m_9236_().m_5776_() && this.wasStatue() && this.getKeyframeAnimationTicks() == 1) {
            this.setPose(CopperGolemEntityPose.IDLE);
            this.setWasStatue(false);
        }
        if (this.getKeyframeAnimationTicks() > 1) {
            return;
        }
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            KeyframeAnimationContext keyframeAnimationContext;
            if (!keyframeAnimation.getAnimation().looping() || !(keyframeAnimationContext = this.getAnimationContextTracker().get(keyframeAnimation)).isRunning()) continue;
            this.setKeyframeAnimationTicks(keyframeAnimation.getAnimationLengthInTicks());
        }
    }

    @Nullable
    public KeyframeAnimation getKeyframeAnimationByPose() {
        KeyframeAnimation keyframeAnimation = null;
        if (this.isInPose(CopperGolemEntityPose.IDLE)) {
            keyframeAnimation = CopperGolemAnimations.IDLE;
        } else if (this.isInPose(CopperGolemEntityPose.SPIN_HEAD)) {
            keyframeAnimation = CopperGolemAnimations.getSpinHeadKeyframeAnimation(this.getAnimationSpeedModifier());
        } else if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_UP)) {
            keyframeAnimation = CopperGolemAnimations.getPressButtonUpKeyframeAnimation(this.getAnimationSpeedModifier());
        } else if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN)) {
            keyframeAnimation = CopperGolemAnimations.getPressButtonDownKeyframeAnimation(this.getAnimationSpeedModifier());
        }
        return keyframeAnimation;
    }

    public int getCurrentKeyframeAnimationTick() {
        KeyframeAnimation keyframeAnimation = this.getKeyframeAnimationByPose();
        if (keyframeAnimation == null) {
            return 0;
        }
        int totalAnimationTicks = keyframeAnimation.getAnimationLengthInTicks();
        int leftAnimationTicks = this.getKeyframeAnimationTicks();
        return totalAnimationTicks - leftAnimationTicks;
    }

    private void tryToStartKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        if (this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            return;
        }
        if (!this.m_9236_().m_5776_() && !this.isOxidized()) {
            this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
        }
        this.startKeyframeAnimation(keyframeAnimationToStart);
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        int initialTick = this.isOxidized() ? this.f_19797_ - this.getCurrentKeyframeAnimationTick() : this.f_19797_;
        this.startKeyframeAnimation(keyframeAnimationToStart, initialTick);
    }

    public void m_20124_(Pose pose) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        super.m_20124_(pose);
    }

    public void setPose(CopperGolemEntityPose pose) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        super.m_20124_(pose.get());
    }

    public boolean isInPose(CopperGolemEntityPose pose) {
        return this.m_20089_() == pose.get();
    }

    public void startSpinHeadAnimation() {
        if (this.isInPose(CopperGolemEntityPose.SPIN_HEAD)) {
            return;
        }
        this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_HEAD_SPIN.get(), 1.0f, this.m_6100_() - 1.5f);
        this.setPose(CopperGolemEntityPose.SPIN_HEAD);
    }

    public void startPressButtonUpAnimation() {
        if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_UP)) {
            return;
        }
        this.setPose(CopperGolemEntityPose.PRESS_BUTTON_UP);
    }

    public void startPressButtonDownAnimation() {
        if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN)) {
            return;
        }
        this.setPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN);
    }

    public void handleOxidationIncrease() {
        if (this.m_20193_().m_5776_() || this.isImmobilized() || this.isWaxed()) {
            return;
        }
        if (this.m_217043_().m_188501_() < 2.0E-5f) {
            int degradedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() + 1;
            WeatheringCopper.WeatherState[] OxidationLevels = WeatheringCopper.WeatherState.values();
            this.setOxidationLevel(OxidationLevels[degradedOxidationLevelOrdinal]);
        }
    }

    public boolean isOxidized() {
        return this.getOxidationLevel() == WeatheringCopper.WeatherState.OXIDIZED;
    }

    public boolean isDegraded() {
        return this.getOxidationLevel().ordinal() > WeatheringCopper.WeatherState.UNAFFECTED.ordinal();
    }

    public WeatheringCopper.WeatherState getOxidationLevel() {
        return WeatheringCopper.WeatherState.values()[(Integer)this.f_19804_.m_135370_(OXIDATION_LEVEL)];
    }

    public void setOxidationLevel(WeatheringCopper.WeatherState oxidationLevel) {
        this.f_19804_.m_135381_(OXIDATION_LEVEL, (Object)oxidationLevel.ordinal());
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.2f * this.getMovementSpeedModifier()));
        if (this.isOxidized()) {
            this.setWasStatue(true);
        }
        if (!this.isImmobilized()) {
            this.refreshAnimationContextTracker();
        }
        if (this.isOxidized() && this.m_6274_().m_257414_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get()).isEmpty()) {
            this.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)true);
            this.becomeStatue();
        } else if (!this.isOxidized() && this.m_6274_().m_257414_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get()).isPresent()) {
            this.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get());
            this.becomeEntity();
        }
    }

    public void setStructByLightningTicks(int structByLightningTicks) {
        this.f_19804_.m_135381_(STRUCT_BY_LIGHTNING_TICKS, (Object)structByLightningTicks);
    }

    public int getStructByLightningTicks() {
        return (Integer)this.f_19804_.m_135370_(STRUCT_BY_LIGHTNING_TICKS);
    }

    public void refreshStructByLightningTicks() {
        this.setStructByLightningTicks(this.m_217043_().m_216332_(1200, 2400));
    }

    public boolean isStructByLightning() {
        return this.getStructByLightningTicks() > 0;
    }

    @Nullable
    public GlobalPos getButtonPos() {
        return this.m_6274_().m_257414_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get()).orElse(null);
    }

    public boolean isButtonValidToBePressed(BlockPos pos) {
        return this.m_9236_().m_8055_(pos).m_204336_(FriendsAndFoesTags.COPPER_BUTTONS);
    }

    private void becomeStatue() {
        CompoundTag entitySnapshot = this.takeEntitySnapshot();
        this.setEntitySnapshot(entitySnapshot);
    }

    private void becomeEntity() {
        CopperGolemBrain.setSpinHeadCooldown(this);
        CopperGolemBrain.setPressButtonCooldown(this);
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(IS_WAXED);
    }

    public void setIsWaxed(boolean isWaxed) {
        this.f_19804_.m_135381_(IS_WAXED, (Object)isWaxed);
    }

    public boolean wasStatue() {
        return (Boolean)this.f_19804_.m_135370_(WAS_STATUE);
    }

    public void setWasStatue(boolean wasStatue) {
        this.f_19804_.m_135381_(WAS_STATUE, (Object)wasStatue);
    }

    public boolean isImmobilized() {
        return this.isOxidized() || this.wasStatue();
    }

    public void setSpawnYaw(float yaw) {
        this.f_20907_ = yaw;
        this.f_19859_ = yaw;
        this.m_146922_(yaw);
        this.f_20884_ = yaw;
        this.f_20883_ = yaw;
        this.f_20933_ = yaw;
        this.f_20886_ = yaw;
        this.f_20885_ = yaw;
    }

    final class CopperGolemMoveControl
    extends MoveControl {
        public CopperGolemMoveControl(CopperGolemEntity copperGolem) {
            super((Mob)copperGolem);
        }

        public void m_8126_() {
            if (CopperGolemEntity.this.isImmobilized()) {
                return;
            }
            super.m_8126_();
        }
    }

    final class CopperGolemLookControl
    extends LookControl {
        public CopperGolemLookControl(CopperGolemEntity copperGolem) {
            super((Mob)copperGolem);
        }

        public void m_8128_() {
            if (CopperGolemEntity.this.isImmobilized()) {
                return;
            }
            super.m_8128_();
        }
    }
}

