/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.RascalAnimations;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.ai.brain.RascalBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.RascalEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.util.RandomGenerator;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public final class RascalEntity
extends AgeableMob
implements AnimatedEntity {
    private AnimationContextTracker animationContextTracker;
    private static final EntityDataAccessor<Integer> POSE_TICKS = SynchedEntityData.m_135353_(RascalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CAUGHT_COUNT = SynchedEntityData.m_135353_(RascalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean ambientSounds;

    public RascalEntity(EntityType<? extends AgeableMob> entityType, Level world) {
        super(entityType, world);
        this.setPose(RascalEntityPose.IDLE);
        this.enableAmbientSounds();
        this.m_21441_(BlockPathTypes.RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData superEntityData = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        this.setPose(RascalEntityPose.IDLE);
        RascalBrain.setNodCooldown(this);
        return superEntityData;
    }

    public static boolean canSpawn(EntityType<? extends Mob> rascalEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        if (spawnReason == MobSpawnType.NATURAL) {
            ServerLevel serverWorld = serverWorldAccess.m_6018_();
            Registry structureRegistry = serverWorldAccess.m_9598_().m_175515_(Registries.f_256944_);
            StructureManager structureAccessor = serverWorld.m_215010_();
            if (!(blockPos.m_123342_() <= 63 && !serverWorldAccess.m_45527_(blockPos) && serverWorldAccess.m_46849_(blockPos, 0) != 0 && (serverWorldAccess.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_13090_) || serverWorldAccess.m_8055_(blockPos.m_7494_()).m_204336_(BlockTags.f_13090_) || serverWorldAccess.m_8055_(blockPos.m_122012_()).m_204336_(BlockTags.f_13090_) || serverWorldAccess.m_8055_(blockPos.m_122024_()).m_204336_(BlockTags.f_13090_) || serverWorldAccess.m_8055_(blockPos.m_122019_()).m_204336_(BlockTags.f_13090_) || serverWorldAccess.m_8055_(blockPos.m_122029_()).m_204336_(BlockTags.f_13090_)))) {
                return false;
            }
            for (Holder structure : structureRegistry.m_203561_(StructureTags.f_215890_)) {
                if (!structureAccessor.m_220524_(blockPos, (Structure)structure.m_203334_()).m_73603_()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
                this.animationContextTracker.add(keyframeAnimation);
            }
            this.animationContextTracker.add(this.getMovementAnimation());
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return RascalAnimations.ANIMATIONS;
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        return RascalAnimations.WALK;
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return (Integer)this.f_19804_.m_135370_(POSE_TICKS);
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.f_19804_.m_135381_(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POSE_TICKS, (Object)0);
        this.f_19804_.m_135372_(CAUGHT_COUNT, (Object)0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return RascalBrain.create(dynamic);
    }

    public Brain<RascalEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("rascalBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("rascalActivityUpdate");
        RascalBrain.updateActivities(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createRascalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.55).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        KeyframeAnimation keyframeAnimationToStart;
        if (!FriendsAndFoes.getConfig().enableRascal) {
            this.m_146870_();
        }
        MobEffectInstance invisibilityStatusEffect = this.m_21124_(MobEffects.f_19609_);
        if (this.isHidden() && invisibilityStatusEffect != null && invisibilityStatusEffect.m_19557_() == 1) {
            this.playReappearSound();
        }
        if (!this.m_9236_().m_5776_()) {
            this.updateKeyframeAnimationTicks();
        }
        if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null) {
            this.tryToStartKeyframeAnimation(keyframeAnimationToStart);
        }
        super.m_8119_();
    }

    @Nullable
    private KeyframeAnimation getKeyframeAnimationByPose() {
        KeyframeAnimation keyframeAnimation = null;
        if (this.isInPose(RascalEntityPose.IDLE) && !this.isMoving()) {
            keyframeAnimation = RascalAnimations.IDLE;
        } else if (this.isInPose(RascalEntityPose.NOD)) {
            keyframeAnimation = RascalAnimations.NOD;
        } else if (this.isInPose(RascalEntityPose.GIVE_REWARD)) {
            keyframeAnimation = RascalAnimations.GIVE_REWARD;
        }
        return keyframeAnimation;
    }

    private void tryToStartKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        if (this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
        }
        this.startKeyframeAnimation(keyframeAnimationToStart);
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        this.startKeyframeAnimation(keyframeAnimationToStart, this.f_19797_);
    }

    public void m_20124_(Pose pose) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        super.m_20124_(pose);
    }

    public void setPose(RascalEntityPose pose) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        super.m_20124_(pose.get());
    }

    public boolean isInPose(RascalEntityPose pose) {
        return this.m_20089_() == pose.get();
    }

    public void startNodAnimation() {
        if (this.isInPose(RascalEntityPose.NOD)) {
            return;
        }
        this.playNodSound();
        this.setPose(RascalEntityPose.NOD);
    }

    public void startGiveRewardAnimation() {
        if (this.isInPose(RascalEntityPose.GIVE_REWARD)) {
            return;
        }
        this.playRewardSound();
        this.setPose(RascalEntityPose.GIVE_REWARD);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof Player) || this.m_8077_()) {
            return super.m_6469_(source, amount);
        }
        this.m_6677_(source);
        this.playDisappearSound();
        this.spawnCloudParticles();
        this.spawnAngerParticles();
        this.m_146870_();
        return false;
    }

    public SoundEvent getNodSound() {
        return FriendsAndFoesSoundEvents.ENTITY_RASCAL_NOD.get();
    }

    public void playNodSound() {
        this.m_5496_(this.getNodSound(), 1.0f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    public SoundEvent getRewardSound() {
        return FriendsAndFoesSoundEvents.ENTITY_RASCAL_REWARD.get();
    }

    public void playRewardSound() {
        this.m_5496_(this.getRewardSound(), 1.0f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    public SoundEvent getBadRewardSound() {
        return FriendsAndFoesSoundEvents.ENTITY_RASCAL_REWARD_BAD.get();
    }

    public void playBadRewardSound() {
        this.m_5496_(this.getBadRewardSound(), 1.0f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    protected SoundEvent m_7515_() {
        return FriendsAndFoesSoundEvents.ENTITY_RASCAL_AMBIENT.get();
    }

    public void m_8032_() {
        if (this.isHidden() || !this.ambientSounds) {
            return;
        }
        SoundEvent soundEvent = this.m_7515_();
        this.m_5496_(soundEvent, 1.5f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_RASCAL_HURT.get();
    }

    protected void m_6677_(DamageSource source) {
        this.f_21363_ = -this.m_8100_();
        this.m_5496_(this.m_7975_(source), 1.0f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    public SoundEvent getDisappearSound() {
        return FriendsAndFoesSoundEvents.ENTITY_RASCAL_DISAPPEAR.get();
    }

    public void playDisappearSound() {
        SoundEvent soundEvent = this.getDisappearSound();
        this.m_5496_(soundEvent, 2.0f, RandomGenerator.generateFloat(1.5f, 1.6f));
    }

    public SoundEvent getReappearSound() {
        return FriendsAndFoesSoundEvents.ENTITY_RASCAL_REAPPEAR.get();
    }

    public void playReappearSound() {
        SoundEvent soundEvent = this.getReappearSound();
        this.m_5496_(soundEvent, 2.0f, RandomGenerator.generateFloat(1.5f, 1.6f));
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.isHidden() || state.m_60767_().m_76332_()) {
            return;
        }
        super.m_7355_(pos, state);
    }

    public boolean isHidden() {
        return this.m_6274_().m_257414_(MemoryModuleType.f_26383_).orElse(null) instanceof Player;
    }

    public boolean isMoving() {
        return this.m_20096_() && this.m_20184_().m_82556_() >= 1.0E-4;
    }

    public int getCaughtCount() {
        return (Integer)this.f_19804_.m_135370_(CAUGHT_COUNT);
    }

    public void addToCaughtCount() {
        this.f_19804_.m_135381_(CAUGHT_COUNT, (Object)(this.getCaughtCount() + 1));
    }

    public boolean shouldGiveReward() {
        return this.getCaughtCount() == 3;
    }

    public boolean disableAmbientSounds() {
        this.ambientSounds = false;
        return false;
    }

    public boolean enableAmbientSounds() {
        this.ambientSounds = true;
        return true;
    }

    public void spawnCloudParticles() {
        ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.f_123796_, 16, 0.1);
    }

    public void spawnAngerParticles() {
        ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.f_123792_, 16, 0.1);
    }
}

