/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.CrabAnimations;
import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CrabBrain;
import com.faboslav.friendsandfoes.common.entity.pose.CrabEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public final class CrabWaveTask
extends Behavior<CrabEntity> {
    private static final int WAVE_DURATION = CrabAnimations.WAVE.getAnimationLengthInTicks();
    private LivingEntity nearestTarget;
    private int waveTicks = 0;
    private int maxWaveTicks = 0;

    public CrabWaveTask() {
        super(Map.of(MemoryModuleType.f_26368_, MemoryStatus.VALUE_PRESENT, MemoryModuleType.f_26375_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_148196_, MemoryStatus.VALUE_ABSENT, FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT, FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), MemoryStatus.VALUE_ABSENT, FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), MemoryStatus.VALUE_ABSENT), WAVE_DURATION);
    }

    protected boolean shouldRun(ServerLevel world, CrabEntity crab) {
        if (crab.m_21573_().m_26572_()) {
            return false;
        }
        LivingEntity nearestTarget = crab.m_6274_().m_257414_(MemoryModuleType.f_26368_).orElse(null);
        if (nearestTarget == null) {
            return false;
        }
        this.nearestTarget = nearestTarget;
        return true;
    }

    protected void run(ServerLevel world, CrabEntity crab, long time) {
        MovementUtil.stopMovement((Mob)crab);
        BehaviorUtils.m_22595_((LivingEntity)crab, (LivingEntity)this.nearestTarget);
        crab.m_21563_().m_148051_((Entity)this.nearestTarget);
        crab.m_21563_().m_8128_();
        this.waveTicks = 0;
        this.maxWaveTicks = WAVE_DURATION;
        crab.startWaveAnimation();
    }

    protected boolean shouldKeepRunning(ServerLevel world, CrabEntity crab, long time) {
        return this.waveTicks <= this.maxWaveTicks;
    }

    protected void keepRunning(ServerLevel world, CrabEntity crab, long time) {
        ++this.waveTicks;
    }

    protected void finishRunning(ServerLevel world, CrabEntity crab, long time) {
        crab.setPose(CrabEntityPose.IDLE);
        CrabBrain.setWaveCooldown(crab);
    }
}

