/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareBeGrumpyAtDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareLocateDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareLocateGlowBerriesTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareShakeGlowBerriesTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareStrollTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTeleportToOwnerTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToGlowBerriesTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSensorTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;

public final class GlareBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super GlareEntity>>> SENSORS;
    private static final UniformInt DARK_SPOT_LOCATING_COOLDOWN_PROVIDER;
    private static final UniformInt EAT_GLOW_BERRIES_COOLDOWN_PROVIDER;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.m_21923_(MEMORY_MODULES, SENSORS);
        Brain brain = profile.m_22073_(dynamic);
        GlareBrain.addCoreActivities((Brain<GlareEntity>)brain);
        GlareBrain.addAvoidActivities((Brain<GlareEntity>)brain);
        GlareBrain.addIdleActivities((Brain<GlareEntity>)brain);
        GlareBrain.addDarkSpotActivities((Brain<GlareEntity>)brain);
        GlareBrain.addGlowBerriesActivities((Brain<GlareEntity>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<GlareEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_217781_), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get()), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get())));
    }

    private static void addDarkSpotActivities(Brain<GlareEntity> brain) {
        brain.m_21903_(FriendsAndFoesActivities.GLARE_SHOW_DARK_SPOT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GlareLocateDarkSpotTask())), (Object)Pair.of((Object)1, (Object)((Object)new GlareTravelToDarkSpotTask())), (Object)Pair.of((Object)2, (Object)((Object)new GlareBeGrumpyAtDarkSpotTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26383_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object[])new Pair[0]));
    }

    private static void addGlowBerriesActivities(Brain<GlareEntity> brain) {
        brain.m_21903_(FriendsAndFoesActivities.GLARE_EAT_GLOW_BERRIES.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)GoToWantedItem.m_257684_(glare -> true, (float)1.25f, (boolean)true, (int)32)), (Object)Pair.of((Object)1, (Object)((Object)new GlareLocateGlowBerriesTask())), (Object)Pair.of((Object)2, (Object)((Object)new GlareTravelToGlowBerriesTask())), (Object)Pair.of((Object)3, (Object)((Object)new GlareShakeGlowBerriesTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26383_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addAvoidActivities(Brain<GlareEntity> brain) {
        brain.m_21903_(Activity.f_37991_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.25f, (int)16, (boolean)false))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26383_, (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addIdleActivities(Brain<GlareEntity> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(glare -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove(FriendsAndFoesEntityTypes.GLARE.get(), 1.0f)), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.m_257685_((UniformInt)UniformInt.m_146622_((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, (Object)((Object)new GlareTeleportToOwnerTask())), (Object)Pair.of((Object)4, (Object)StayCloseToTarget.m_257901_(glare -> GlareBrain.getOwner((GlareEntity)glare), (int)3, (int)8, (float)2.0f)), (Object)Pair.of((Object)5, (Object)SetEntityLookTargetSometimes.m_257458_((float)3.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)6, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)3), (Object)Pair.of((Object)((Object)new GlareStrollTask()), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26383_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static Optional<PositionTracker> getOwner(GlareEntity glare) {
        if (!glare.m_21824_() || glare.m_21826_() == null) {
            return Optional.empty();
        }
        return Optional.of(new EntityTracker((Entity)glare.m_21826_(), true));
    }

    public static void updateActivities(GlareEntity glare) {
        glare.m_6274_().m_21926_((List)ImmutableList.of((Object)FriendsAndFoesActivities.GLARE_SHOW_DARK_SPOT.get(), (Object)FriendsAndFoesActivities.GLARE_EAT_GLOW_BERRIES.get(), (Object)Activity.f_37991_, (Object)Activity.f_37979_));
    }

    public static void updateMemories(GlareEntity glare) {
        if ((!glare.m_6162_() && !glare.m_21824_() || !GlareLocateDarkSpotTask.canLocateDarkSpot(glare)) && glare.m_6274_().m_21876_(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT)) {
            GlareBrain.setDarkSpotLocatingCooldown(glare);
        }
        if (glare.m_21827_() || glare.m_21523_() || glare.m_20159_()) {
            glare.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)true);
        } else {
            glare.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get());
        }
        if (glare.m_21824_()) {
            glare.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), (Object)true);
        } else {
            glare.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get());
        }
    }

    public static void setDarkSpotLocatingCooldown(GlareEntity glare) {
        glare.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)DARK_SPOT_LOCATING_COOLDOWN_PROVIDER.m_214085_(glare.m_217043_()));
    }

    public static void setDarkSpotLocatingCooldown(GlareEntity glare, UniformInt cooldown) {
        glare.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)cooldown.m_214085_(glare.m_217043_()));
    }

    public static void setLocatingGlowBerriesCooldown(GlareEntity glare) {
        glare.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)EAT_GLOW_BERRIES_COOLDOWN_PROVIDER.m_214085_(glare.m_217043_()));
    }

    public static void setLocatingGlowBerriesCooldown(GlareEntity glare, UniformInt cooldown) {
        glare.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)cooldown.m_214085_(glare.m_217043_()));
    }

    public static void setItemPickupCooldown(GlareEntity glare) {
        glare.m_6274_().m_21879_(MemoryModuleType.f_217781_, (Object)TimeUtil.m_145020_((int)1, (int)10).m_214085_(glare.m_217043_()));
    }

    public static Ingredient getTemptItems() {
        return Ingredient.m_204132_(FriendsAndFoesTags.GLARE_TEMPT_ITEMS);
    }

    static {
        SENSORS = List.of(SensorType.f_26811_, SensorType.f_26812_, SensorType.f_26810_, SensorType.f_26822_, FriendsAndFoesSensorTypes.GLARE_TEMPTATIONS.get(), FriendsAndFoesSensorTypes.GLARE_SPECIFIC_SENSOR.get());
        MEMORY_MODULES = List.of(MemoryModuleType.f_217768_, MemoryModuleType.f_148196_, MemoryModuleType.f_148197_, MemoryModuleType.f_217781_, MemoryModuleType.f_217768_, MemoryModuleType.f_148198_, MemoryModuleType.f_148205_, MemoryModuleType.f_26377_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26355_, MemoryModuleType.f_26375_, MemoryModuleType.f_26383_, MemoryModuleType.f_26326_, MemoryModuleType.f_26332_, FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get());
        DARK_SPOT_LOCATING_COOLDOWN_PROVIDER = TimeUtil.m_145020_((int)20, (int)40);
        EAT_GLOW_BERRIES_COOLDOWN_PROVIDER = TimeUtil.m_145020_((int)30, (int)60);
    }
}

