/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToDarkSpotTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import java.util.List;
import java.util.Map;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public final class GlareBeGrumpyAtDarkSpotTask
extends Behavior<GlareEntity> {
    private static final int MAX_GRUMPY_TICKS = 200;
    private static final float WITHING_DISTANCE = 2.0f;
    private int grumpyTicks;
    private final ParticleOptions particleEffect = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152541_.m_49966_());

    public GlareBeGrumpyAtDarkSpotTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), MemoryStatus.VALUE_PRESENT), 200);
    }

    protected boolean shouldRun(ServerLevel world, GlareEntity glare) {
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        return GlareBeGrumpyAtDarkSpotTask.canBeGrumpyAtDarkSpot(glare) && darkSpotPos.m_122646_().m_203195_((Position)glare.m_20182_(), 2.0);
    }

    protected void run(ServerLevel world, GlareEntity glare, long time) {
        this.grumpyTicks = 0;
        glare.setGrumpy(true);
        BehaviorUtils.m_22595_((LivingEntity)glare, (LivingEntity)glare.m_21826_());
        this.applyGlowToHostileEntities(glare);
    }

    protected boolean shouldKeepRunning(ServerLevel world, GlareEntity glare, long time) {
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        return GlareBeGrumpyAtDarkSpotTask.canBeGrumpyAtDarkSpot(glare) && darkSpotPos.m_122646_().m_203195_((Position)glare.m_20182_(), 2.0);
    }

    protected void keepRunning(ServerLevel world, GlareEntity glare, long time) {
        ++this.grumpyTicks;
        BehaviorUtils.m_22595_((LivingEntity)glare, (LivingEntity)glare.m_21826_());
        if (!glare.isGrumpy()) {
            glare.setGrumpy(true);
        }
        if (this.grumpyTicks == 10) {
            glare.playGrumpinessSound();
        }
        if (this.grumpyTicks % 3 == 0 && glare.m_217043_().m_188499_()) {
            glare.playRustleSound();
        }
        if (this.grumpyTicks % 2 == 0 && glare.m_217043_().m_188499_()) {
            BlockParticleOption particleEffect = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152541_.m_49966_());
            ParticleSpawner.spawnParticles((LivingEntity)glare, (ParticleOptions)particleEffect, glare.m_217043_().m_216332_(4, 10), 0.1);
        }
    }

    protected void finishRunning(ServerLevel world, GlareEntity glare, long time) {
        glare.setGrumpy(false);
        glare.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get());
        GlareBrain.setDarkSpotLocatingCooldown(glare);
    }

    private void applyGlowToHostileEntities(GlareEntity glare) {
        AABB box = new AABB(glare.m_20183_()).m_82400_(24.0);
        List hostileEntities = glare.m_9236_().m_45976_(Monster.class, box);
        for (Monster hostileEntity : hostileEntities) {
            this.applyGlowToEntity(hostileEntity);
        }
    }

    private void applyGlowToEntity(Monster entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200));
    }

    public static boolean canBeGrumpyAtDarkSpot(GlareEntity glare) {
        return GlareTravelToDarkSpotTask.canTravelToDarkSpot(glare) && glare.m_21826_() != null;
    }
}

