/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.common.modcompat.ModChecker;
import com.faboslav.friendsandfoes.common.modcompat.ModCompat;
import com.faboslav.friendsandfoes.common.network.packet.TotemEffectPacket;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.TotemUtil;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Shadow
    public abstract Iterable<ItemStack> m_6168_();

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void friendsandfoes_addToTick(CallbackInfo ci) {
        this.friendsandfoes_updateWildfireCrown();
    }

    private void friendsandfoes_updateWildfireCrown() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.HEAD);
        if (itemStack.m_150930_(FriendsAndFoesItems.WILDFIRE_CROWN.get()) && !this.m_204029_(FluidTags.f_13132_) && !this.m_6060_()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 160, 0, false, false, true));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage"}, cancellable=true)
    public void friendsandfoes_tryUseTotems(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        ItemStack totemItemStack;
        PlayerEntityMixin entity = this;
        Player player = (Player)this;
        if (!(source.m_19384_() || source.m_146707_() || source.m_146705_() || source.m_7639_() == null || player.m_21224_() || !(this.m_21223_() <= this.m_21233_() / 2.0f) || (totemItemStack = PlayerEntityMixin.friendsandfoes_getTotem(PlayerEntityMixin.friendsandfoes_getTotemFromHands(player), PlayerEntityMixin.friendsandfoes_getTotemFromCustomEquipmentSlots(player))) == null)) {
            if (this instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)this;
                if (totemItemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                    serverPlayerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)FriendsAndFoesItems.TOTEM_OF_FREEZING.get()));
                } else if (totemItemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                    serverPlayerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()));
                }
                CriteriaTriggers.f_10551_.m_74431_(serverPlayerEntity, totemItemStack);
            }
            Item totemItem = totemItemStack.m_41720_();
            this.m_21219_();
            TotemEffectPacket.sendToClient((Player)entity, totemItemStack);
            totemItemStack.m_41774_(1);
            if (totemItem == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                TotemUtil.freezeEntities(player);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 1));
            } else if (totemItem == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                TotemUtil.createIllusions(player);
            }
        }
    }

    @Nullable
    private static ItemStack friendsandfoes_getTotem(ItemStack ... itemStacks) {
        return Arrays.stream(itemStacks).filter(Objects::nonNull).toList().stream().findFirst().orElse(null);
    }

    @Nullable
    private static ItemStack friendsandfoes_getTotemFromHands(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemStack = player.m_21120_(hand);
            if (!PlayerEntityMixin.friendsandfoes_isTotem(itemStack)) continue;
            return itemStack;
        }
        return null;
    }

    @Nullable
    private static ItemStack friendsandfoes_getTotemFromCustomEquipmentSlots(Player player) {
        for (ModCompat compat : ModChecker.CUSTOM_EQUIPMENT_SLOTS_COMPATS) {
            ItemStack itemStack = compat.getEquippedItemFromCustomSlots((Entity)player, PlayerEntityMixin::friendsandfoes_isTotem);
            if (itemStack == null) continue;
            return itemStack;
        }
        return null;
    }

    private static boolean friendsandfoes_isTotem(ItemStack itemStack) {
        return itemStack.m_204117_(FriendsAndFoesTags.TOTEMS);
    }
}

