/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.forge.datagen;

import com.google.common.hash.Hashing;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerUpper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class StructureNbtUpdater
implements DataProvider {
    private final String basePath;
    private final String modid;
    private final PackOutput output;
    private final MultiPackResourceManager resources;

    public StructureNbtUpdater(String basePath, String modid, ExistingFileHelper helper, PackOutput output) {
        this.basePath = basePath;
        this.modid = modid;
        this.output = output;
        try {
            Field serverData = ExistingFileHelper.class.getDeclaredField("serverData");
            serverData.setAccessible(true);
            this.resources = (MultiPackResourceManager)serverData.get(helper);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
        try {
            for (Map.Entry entry : this.resources.m_214159_(this.basePath, $ -> true).entrySet()) {
                if (!((ResourceLocation)entry.getKey()).m_135827_().equals(this.modid)) continue;
                this.process((ResourceLocation)entry.getKey(), (Resource)entry.getValue(), cache);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (IOException x) {
            return CompletableFuture.failedFuture(x);
        }
    }

    private void process(ResourceLocation loc, Resource resource, CachedOutput cache) throws IOException {
        CompoundTag inputNBT = NbtIo.m_128939_((InputStream)resource.m_215507_());
        CompoundTag converted = StructureNbtUpdater.updateNBT(inputNBT);
        if (!converted.equals((Object)inputNBT)) {
            Class<?> fixerClass = DataFixers.m_14512_().getClass();
            if (!fixerClass.equals(DataFixerUpper.class)) {
                throw new RuntimeException("Structures are not up to date, but unknown data fixer is in use: " + fixerClass.getName());
            }
            this.writeNBTTo(loc, converted, cache);
        }
    }

    private void writeNBTTo(ResourceLocation loc, CompoundTag data, CachedOutput cache) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        NbtIo.m_128947_((CompoundTag)data, (OutputStream)bytearrayoutputstream);
        byte[] bytes = bytearrayoutputstream.toByteArray();
        Path outputPath = this.output.m_245114_().resolve("data/" + loc.m_135827_() + "/" + loc.m_135815_());
        cache.m_213871_(outputPath, bytes, Hashing.sha1().hashBytes(bytes));
    }

    private static CompoundTag updateNBT(CompoundTag nbt) {
        CompoundTag updatedNBT = NbtUtils.m_129213_((DataFixer)DataFixers.m_14512_(), (DataFixTypes)DataFixTypes.STRUCTURE, (CompoundTag)nbt, (int)nbt.m_128451_("DataVersion"));
        StructureTemplate template = new StructureTemplate();
        template.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), updatedNBT);
        return template.m_74618_(new CompoundTag());
    }

    @Nonnull
    public String m_6055_() {
        return "Update structure files in " + this.basePath;
    }
}

