/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1068;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_640;
import org.jetbrains.annotations.Nullable;

public final class PlayerIllusionEntity
extends class_1308 {
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final class_2940<Integer> TICKS_UNTIL_DESPAWN;
    private static final String PLAYER_UUID_NBT_NAME = "PlayerUuid";
    private static final class_2940<Optional<UUID>> PLAYER_UUID;
    private static final class_2940<Byte> PLAYER_MODEL_PARTS;
    @Nullable
    private class_1657 player;
    @Nullable
    private class_640 playerListEntry;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;
    public float prevStrideDistance;
    public float strideDistance;

    public PlayerIllusionEntity(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PLAYER_MODEL_PARTS, (Object)0);
        this.field_6011.method_12784(TICKS_UNTIL_DESPAWN, (Object)0);
        this.field_6011.method_12784(PLAYER_UUID, Optional.empty());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        nbt.method_25927(PLAYER_UUID_NBT_NAME, this.getPlayerUuid());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setPlayerUuid(nbt.method_25926(PLAYER_UUID_NBT_NAME));
        this.setTicksUntilDespawn(nbt.method_10550(TICKS_UNTIL_DESPAWN_NBT_NAME));
    }

    public boolean method_6054() {
        return false;
    }

    protected boolean method_27071() {
        return false;
    }

    public void method_6007() {
        boolean isPlayerNonExistingOrDead;
        super.method_6007();
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isPlayerNonExistingOrDead = this.getPlayer() != null && !this.getPlayer().method_5805();
        if (this.getTicksUntilDespawn() == 0 || isPlayerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        this.discardIllusion();
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isPartVisible(class_1664 modelPart) {
        return ((Byte)this.method_5841().method_12789(PLAYER_MODEL_PARTS) & modelPart.method_7430()) == modelPart.method_7430();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasSkinTexture() {
        class_640 playerListEntry = this.getPlayerListEntry();
        return playerListEntry != null && playerListEntry.method_2967();
    }

    @Environment(value=EnvType.CLIENT)
    public class_2960 getSkinTexture() {
        class_640 playerListEntry = this.getPlayerListEntry();
        UUID uuid = this.getPlayerUuid();
        if (uuid == null) {
            uuid = this.method_5667();
        }
        return playerListEntry == null ? class_1068.method_4648((UUID)uuid) : playerListEntry.method_2968();
    }

    @Environment(value=EnvType.CLIENT)
    public String getModel() {
        class_640 playerListEntry = this.getPlayerListEntry();
        UUID uuid = this.getPlayerUuid();
        if (uuid == null) {
            uuid = this.method_5667();
        }
        String model = playerListEntry == null ? class_1068.method_4647((UUID)uuid) : playerListEntry.method_2977();
        return model;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_2960 getCapeTexture() {
        class_640 playerListEntry = this.getPlayerListEntry();
        return playerListEntry == null ? null : playerListEntry.method_2979();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean canRenderElytraTexture() {
        return this.getPlayerListEntry() != null;
    }

    @Nullable
    public class_2960 getElytraTexture() {
        class_640 playerListEntry = this.getPlayerListEntry();
        return playerListEntry == null ? null : playerListEntry.method_2957();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean canRenderCapeTexture() {
        return this.getPlayerListEntry() != null;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    private class_640 getPlayerListEntry() {
        if (this.playerListEntry == null) {
            UUID uuid = this.getPlayerUuid();
            if (uuid == null) {
                uuid = this.method_5667();
            }
            this.playerListEntry = class_310.method_1551().method_1562().method_2871(uuid);
        }
        return this.playerListEntry;
    }

    @Nullable
    public UUID getPlayerUuid() {
        return ((Optional)this.field_6011.method_12789(PLAYER_UUID)).orElse(null);
    }

    public void setPlayerUuid(UUID uuid) {
        this.field_6011.method_12778(PLAYER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public class_1657 getPlayer() {
        return this.player;
    }

    public void setPlayer(class_1657 player) {
        this.player = player;
    }

    public int getTicksUntilDespawn() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_DESPAWN);
    }

    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.field_6011.method_12778(TICKS_UNTIL_DESPAWN, (Object)ticksUntilDespawn);
    }

    private void discardIllusion() {
        this.playMirrorSound();
        this.spawnCloudParticles();
        this.method_31472();
    }

    private void playMirrorSound() {
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), this.method_6107(), this.method_6017());
    }

    public boolean tryToTeleport(int x, int y, int z) {
        double bottomY = Math.max(y -= 8, this.method_37908().method_31607());
        double topY = Math.min(bottomY + 16.0, (double)(((class_3218)this.method_37908()).method_32819() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.method_6082(x, y = (int)class_3532.method_15350((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    public void spawnCloudParticles() {
        this.spawnParticles(class_2398.field_11204, 16);
    }

    private void spawnParticles(class_2400 particleType, int amount) {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)this.method_5770()).method_14199((class_2394)particleType, this.method_23322(0.5), this.method_23319() + 0.5, this.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    static {
        PLAYER_MODEL_PARTS = class_2945.method_12791(PlayerIllusionEntity.class, (class_2941)class_2943.field_13319);
        TICKS_UNTIL_DESPAWN = class_2945.method_12791(PlayerIllusionEntity.class, (class_2941)class_2943.field_13327);
        PLAYER_UUID = class_2945.method_12791(PlayerIllusionEntity.class, (class_2941)class_2943.field_13313);
    }
}

