/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.TuffGolemAnimations;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.ai.brain.TuffGolemBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.TuffGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1427;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5953;
import org.jetbrains.annotations.Nullable;

public final class TuffGolemEntity
extends class_1427
implements AnimatedEntity {
    private static final class_2940<String> COLOR = class_2945.method_12791(TuffGolemEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<class_4050> PREV_POSE = class_2945.method_12791(TuffGolemEntity.class, (class_2941)class_2943.field_18238);
    private static final class_2940<Integer> POSE_TICKS = class_2945.method_12791(TuffGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_GLUED = class_2945.method_12791(TuffGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2487> HOME = class_2945.method_12791(TuffGolemEntity.class, (class_2941)class_2943.field_13318);
    private static final float MOVEMENT_SPEED = 0.225f;
    private static final float MOVEMENT_SPEED_WITH_ITEM = 0.175f;
    private static final int TUFF_HEAL_AMOUNT = 5;
    private static final int INACTIVE_TICKS_AFTER_SPAWN = 200;
    private static final String COLOR_NBT_NAME = "Color";
    private static final String PREV_POSE_NBT_NAME = "PrevPose";
    private static final String POSE_NBT_NAME = "Pose";
    private static final String IS_GLUED_NBT_NAME = "IsGlued";
    private static final String HOME_NBT_NAME = "Home";
    private static final String HOME_NBT_NAME_X = "x";
    private static final String HOME_NBT_NAME_Y = "y";
    private static final String HOME_NBT_NAME_Z = "z";
    private static final String HOME_NBT_NAME_YAW = "yaw";
    private int inactiveTicksAfterSpawn = 0;
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
                this.animationContextTracker.add(keyframeAnimation);
            }
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return TuffGolemAnimations.ANIMATIONS;
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        if (this.isHoldingItem()) {
            return TuffGolemAnimations.WALK_WITH_ITEM;
        }
        return TuffGolemAnimations.WALK;
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return (Integer)this.field_6011.method_12789(POSE_TICKS);
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.field_6011.method_12778(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    public TuffGolemEntity(class_1299<? extends TuffGolemEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_1315 superEntityData = super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
        if (spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462) {
            float randomSpawnYaw = 90.0f * (float)this.method_6051().method_39332(0, 3);
            this.setSpawnYaw(randomSpawnYaw);
        }
        this.setPrevPose(TuffGolemEntityPose.STANDING.get());
        this.setPoseWithoutPrevPose(TuffGolemEntityPose.STANDING.get());
        this.setHome(this.getNewHome());
        TuffGolemBrain.setSleepCooldown(this);
        this.inactiveTicksAfterSpawn = 200;
        return superEntityData;
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return TuffGolemBrain.create(dynamic);
    }

    public class_4095<TuffGolemEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("tuffGolemBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("tuffGolemActivityUpdate");
        TuffGolemBrain.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public static class_5132.class_5133 createTuffGolemAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.225f).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)Color.RED.getName());
        this.field_6011.method_12784(PREV_POSE, (Object)TuffGolemEntityPose.STANDING.get());
        this.field_6011.method_12784(POSE_TICKS, (Object)0);
        this.field_6011.method_12784(IS_GLUED, (Object)false);
        this.field_6011.method_12784(HOME, (Object)new class_2487());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(COLOR_NBT_NAME, this.getColor().getName());
        nbt.method_10582(PREV_POSE_NBT_NAME, this.getPrevPose().name());
        nbt.method_10582(POSE_NBT_NAME, this.method_18376().name());
        nbt.method_10556(IS_GLUED_NBT_NAME, this.isGlued());
        nbt.method_10566(HOME_NBT_NAME, (class_2520)this.getHome());
    }

    public void method_5749(class_2487 nbt) {
        String savedPose;
        String prevSavedPose;
        super.method_5749(nbt);
        this.setColor(Color.fromName(nbt.method_10558(COLOR_NBT_NAME)));
        this.setGlued(nbt.method_10577(IS_GLUED_NBT_NAME));
        this.setHome(nbt.method_10562(HOME_NBT_NAME));
        if (this.isAtHomePos()) {
            this.setSpawnYaw(this.getHomeYaw());
        }
        if ((prevSavedPose = nbt.method_10558(PREV_POSE_NBT_NAME)) != "") {
            this.setPrevPose(class_4050.valueOf((String)nbt.method_10558(PREV_POSE_NBT_NAME)));
        }
        if ((savedPose = nbt.method_10558(POSE_NBT_NAME)) != "") {
            this.setPoseWithoutPrevPose(class_4050.valueOf((String)nbt.method_10558(POSE_NBT_NAME)));
            class_4050 entityPose = class_4050.valueOf((String)nbt.method_10558(POSE_NBT_NAME));
            if (!(this.method_37908().method_8608() || entityPose != TuffGolemEntityPose.SLEEPING.get() && entityPose != TuffGolemEntityPose.SLEEPING_WITH_ITEM.get())) {
                this.method_18868().method_18875(class_4140.field_18445);
                this.method_18868().method_18875(class_4140.field_18446);
                TuffGolemBrain.resetSleepCooldown(this);
            } else {
                this.setPoseWithoutPrevPose(entityPose);
            }
        }
    }

    private class_3414 getGlueOnSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_GLUE_ON.get();
    }

    private void playGlueOnSound() {
        this.method_5783(this.getGlueOnSound(), 1.0f, 1.0f);
    }

    private class_3414 getGlueOffSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_GLUE_OFF.get();
    }

    private void playGlueOffSound() {
        this.method_5783(this.getGlueOffSound(), 1.0f, 1.0f);
    }

    public class_3414 getMoveSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_MOVE.get();
    }

    public void playMoveSound() {
        this.method_5783(this.getMoveSound(), 1.0f, 1.05f + this.method_6051().method_43057() * 0.05f);
    }

    private class_3414 getRepairSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_REPAIR.get();
    }

    private void playRepairSound() {
        this.method_5783(this.getRepairSound(), 1.0f, 1.0f + (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.2f);
    }

    public class_3414 getWakeSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_WAKE.get();
    }

    public void playWakeSound() {
        this.method_5783(this.getWakeSound(), 1.0f, 1.05f + this.method_6051().method_43057() * 0.05f);
    }

    public class_3414 getSleepSound() {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_SLEEP.get();
    }

    public void playSleepSound() {
        this.method_5783(this.getSleepSound(), 1.0f, 1.05f + this.method_6051().method_43057() * 0.05f);
    }

    protected class_3414 method_6011(class_1282 source) {
        return FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_HURT.get();
    }

    protected void method_6013(class_1282 source) {
        this.field_6191 = -this.method_5970();
        this.method_5783(this.method_6011(source), 2.0f, 0.7f + this.method_6051().method_43057() * 0.15f);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (this.isInSleepingPose() || state.method_26207().method_15797()) {
            return;
        }
        class_2680 blockState = this.method_37908().method_8320(pos.method_10084());
        class_2498 blockSoundGroup = blockState.method_26164(class_3481.field_28040) ? blockState.method_26231() : state.method_26231();
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_TUFF_GOLEM_STEP.get(), blockSoundGroup.method_10597(), 0.75f + this.method_6051().method_43057() * 0.15f);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 itemInHand = itemStack.method_7909();
        boolean interactionResult = false;
        if (itemInHand == class_1802.field_27021) {
            interactionResult = this.tryToInteractMobWithTuff(player, itemStack);
        } else if (itemInHand instanceof class_1769) {
            interactionResult = this.tryToInteractMobWithDye(player, itemStack);
        } else if (itemInHand instanceof class_5953) {
            interactionResult = this.tryToInteractMobWithHoneycomb(player, itemStack);
        } else if (itemInHand instanceof class_1743) {
            interactionResult = this.tryToInteractMobWithAxe(player, hand, itemStack);
        }
        if (!interactionResult) {
            interactionResult = this.tryToInteractMobWithItem(player, itemStack);
        }
        if (interactionResult) {
            this.method_32875(class_5712.field_28725, (class_1297)this);
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    private boolean tryToInteractMobWithTuff(class_1657 player, class_1799 itemStack) {
        if (this.method_6032() >= this.method_6063()) {
            return false;
        }
        this.method_6025(5.0f);
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.playRepairSound();
        return true;
    }

    private boolean tryToInteractMobWithDye(class_1657 player, class_1799 itemStack) {
        Color usedColor = Color.fromDyeColor(((class_1769)itemStack.method_7909()).method_7802());
        if (this.getColor() == usedColor) {
            return false;
        }
        this.setColor(usedColor);
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.method_5783(class_3417.field_28391, 1.0f, 1.0f);
        return true;
    }

    private boolean tryToInteractMobWithHoneycomb(class_1657 player, class_1799 itemStack) {
        if (this.isGlued()) {
            return false;
        }
        this.setGlued(true);
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.playGlueOnSound();
        ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_29642, 7, 1.0);
        return true;
    }

    private boolean tryToInteractMobWithAxe(class_1657 player, class_1268 hand, class_1799 itemStack) {
        if (!this.isGlued()) {
            return false;
        }
        this.setGlued(false);
        this.playGlueOffSound();
        ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_29643, 7, 1.0);
        if (!this.method_37908().method_8608() && !player.method_31549().field_7477) {
            itemStack.method_7956(1, (class_1309)player, playerEntity -> player.method_20236(hand));
        }
        return true;
    }

    private boolean tryToInteractMobWithItem(class_1657 player, class_1799 itemStack) {
        if (this.method_6118(class_1304.field_6173).method_7909() == class_1802.field_8162 && itemStack.method_7909() == class_1802.field_8162 || itemStack.method_7909() instanceof class_1826 || this.isAnyKeyframeAnimationRunning()) {
            return false;
        }
        MovementUtil.stopMovement((class_1308)this);
        if (this.isHoldingItem()) {
            if (!player.method_31549().field_7477) {
                this.method_5775(this.method_6118(class_1304.field_6173));
            }
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
            this.startStanding();
        } else {
            class_1799 itemsStackToBeEquipped = itemStack.method_7972();
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            itemsStackToBeEquipped.method_7939(1);
            this.method_5673(class_1304.field_6173, itemsStackToBeEquipped);
            this.startStandingWithItem();
        }
        return true;
    }

    public void setColor(Color color) {
        this.field_6011.method_12778(COLOR, (Object)color.getName());
    }

    public Color getColor() {
        return Color.fromName((String)this.field_6011.method_12789(COLOR));
    }

    public void method_18380(class_4050 pose) {
        if (this.method_37908().method_8608()) {
            return;
        }
        this.setPrevPose(this.method_18376());
        super.method_18380(pose);
    }

    public void setPoseWithoutPrevPose(class_4050 pose) {
        if (this.method_37908().method_8608()) {
            return;
        }
        super.method_18380(pose);
    }

    public void setPrevPose(class_4050 pose) {
        if (this.method_37908().method_8608()) {
            return;
        }
        this.field_6011.method_12778(PREV_POSE, (Object)pose);
    }

    public class_4050 getPrevPose() {
        return (class_4050)this.field_6011.method_12789(PREV_POSE);
    }

    public boolean isInPose(TuffGolemEntityPose pose) {
        return this.method_18376() == pose.get();
    }

    public boolean wasInPose(TuffGolemEntityPose pose) {
        return this.getPrevPose() == pose.get();
    }

    public boolean isInStandingPose() {
        return this.isInPose(TuffGolemEntityPose.STANDING) || this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM);
    }

    public boolean isInSleepingPose() {
        return this.isInPose(TuffGolemEntityPose.SLEEPING) || this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM);
    }

    public boolean isInHoldingItemPose() {
        return this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM) || this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM);
    }

    public void setGlued(boolean isGlued) {
        this.field_6011.method_12778(IS_GLUED, (Object)isGlued);
    }

    public boolean isGlued() {
        return (Boolean)this.field_6011.method_12789(IS_GLUED);
    }

    public class_2487 getNewHome() {
        class_2487 home = new class_2487();
        home.method_10549(HOME_NBT_NAME_X, this.method_19538().method_10216());
        home.method_10549(HOME_NBT_NAME_Y, this.method_19538().method_10214());
        home.method_10549(HOME_NBT_NAME_Z, this.method_19538().method_10215());
        home.method_10548(HOME_NBT_NAME_YAW, this.field_6283);
        return home;
    }

    public void setHome(class_2487 home) {
        this.field_6011.method_12778(HOME, (Object)home);
    }

    public class_2487 getHome() {
        return (class_2487)this.field_6011.method_12789(HOME);
    }

    public class_243 getHomePos() {
        return new class_243(this.getHome().method_10574(HOME_NBT_NAME_X), this.getHome().method_10574(HOME_NBT_NAME_Y), this.getHome().method_10574(HOME_NBT_NAME_Z));
    }

    public float getHomeYaw() {
        return this.getHome().method_10583(HOME_NBT_NAME_YAW);
    }

    public boolean isAtHomePos() {
        return this.method_5707(this.getHomePos()) < 0.1;
    }

    public boolean isCloseToHomePos(float distance) {
        return this.method_5707(this.getHomePos()) < (double)distance;
    }

    public boolean isAtHomeYaw() {
        return this.field_6284 == (double)this.getHomeYaw() && this.field_5982 == this.getHomeYaw() && this.method_36454() == this.getHomeYaw() && this.field_6220 == this.getHomeYaw() && this.method_43078() == this.getHomeYaw() && this.field_6259 == this.getHomeYaw() && this.method_5791() == this.getHomeYaw();
    }

    public boolean isAtHome() {
        return this.isAtHomePos() && this.isAtHomeYaw();
    }

    public boolean isHoldingItem() {
        return this.method_6118(class_1304.field_6173).method_7909() != class_1802.field_8162;
    }

    public boolean isShowingItem() {
        return this.isHoldingItem() && this.isInHoldingItemPose();
    }

    public boolean isNotImmobilized() {
        return this.getKeyframeAnimationTicks() == 0 && this.inactiveTicksAfterSpawn == 0 && !this.isGlued() && !this.isInSleepingPose();
    }

    public void startSleeping() {
        if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
            return;
        }
        this.playSleepSound();
        this.method_18380(TuffGolemEntityPose.SLEEPING.get());
    }

    public void startSleepingWithItem() {
        if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
            return;
        }
        this.playSleepSound();
        this.method_18380(TuffGolemEntityPose.SLEEPING_WITH_ITEM.get());
    }

    public void startStanding() {
        if (this.isInPose(TuffGolemEntityPose.STANDING)) {
            return;
        }
        if (this.isInSleepingPose()) {
            this.playWakeSound();
        } else {
            this.playMoveSound();
        }
        this.method_18380(TuffGolemEntityPose.STANDING.get());
    }

    public void startStandingWithItem() {
        if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
            return;
        }
        if (this.isInSleepingPose()) {
            this.playWakeSound();
        } else {
            this.playMoveSound();
        }
        this.method_18380(TuffGolemEntityPose.STANDING_WITH_ITEM.get());
    }

    public void method_5773() {
        if (!this.method_37908().method_8608() && !FriendsAndFoes.getConfig().enableTuffGolem) {
            this.method_31472();
        }
        if (!this.method_37908().method_8608() && this.inactiveTicksAfterSpawn > 0) {
            --this.inactiveTicksAfterSpawn;
        }
        this.updateKeyframeAnimations();
        super.method_5773();
    }

    public boolean method_5810() {
        return !this.method_6113();
    }

    private void updateKeyframeAnimations() {
        KeyframeAnimation keyframeAnimationToStart;
        if (!this.method_37908().method_8608()) {
            this.updateKeyframeAnimationTicks();
        }
        if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null && !this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            if (!this.method_37908().method_8608()) {
                this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
            }
            this.startKeyframeAnimation(keyframeAnimationToStart);
        }
    }

    @Nullable
    private KeyframeAnimation getKeyframeAnimationByPose() {
        class_4050 prevPose = this.getPrevPose();
        class_4050 pose = this.method_18376();
        if (pose == prevPose) {
            return null;
        }
        KeyframeAnimation keyframeAnimation = null;
        if (this.wasInPose(TuffGolemEntityPose.STANDING)) {
            if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
                keyframeAnimation = TuffGolemAnimations.SLEEP;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
            if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                keyframeAnimation = TuffGolemAnimations.HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.SLEEP_WITH_ITEM;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.SLEEPING)) {
            if (this.isInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.WAKE_AND_SHOW_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                keyframeAnimation = TuffGolemAnimations.WAKE;
            }
        } else if (this.wasInPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM)) {
            if (this.isInPose(TuffGolemEntityPose.SLEEPING)) {
                keyframeAnimation = TuffGolemAnimations.HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING)) {
                keyframeAnimation = TuffGolemAnimations.WAKE_AND_HIDE_ITEM;
            } else if (this.isInPose(TuffGolemEntityPose.STANDING_WITH_ITEM)) {
                keyframeAnimation = TuffGolemAnimations.WAKE_WITH_ITEM;
            }
        }
        return keyframeAnimation;
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : TuffGolemAnimations.ANIMATIONS) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        this.startKeyframeAnimation(keyframeAnimationToStart, this.field_6012);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1538 || source == class_1282.field_16992) {
            return false;
        }
        if (!this.method_37908().method_8608() && this.isInSleepingPose()) {
            if (this.isHoldingItem()) {
                this.startStandingWithItem();
            } else {
                this.startStanding();
            }
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5931(class_1657 player) {
        return super.method_5931(player) && !this.isInSleepingPose();
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)this.method_5751() * 0.45, 0.0);
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return 0.8f;
    }

    public float method_6029() {
        return this.isHoldingItem() ? 0.175f : 0.225f;
    }

    protected void method_16077(class_1282 source, boolean causedByPlayer) {
        if (this.isHoldingItem()) {
            this.method_5775(this.method_6118(class_1304.field_6173));
        }
        super.method_16077(source, causedByPlayer);
    }

    public float getMovementSpeedModifier() {
        if (this.isHoldingItem()) {
            return 1.0f;
        }
        return 0.7777778f;
    }

    protected int method_6130(int air) {
        return air;
    }

    public void setSpawnYaw(float yaw) {
        this.field_6284 = yaw;
        this.field_5982 = yaw;
        this.method_36456(yaw);
        this.field_6220 = yaw;
        this.method_5636(yaw);
        this.field_6259 = yaw;
        this.method_5847(yaw);
    }

    public static enum Color {
        RED("red"),
        BLACK("black"),
        BLUE("blue"),
        BROWN("brown"),
        CYAN("cyan"),
        GRAY("gray"),
        GREEN("green"),
        LIGHT_BLUE("light_blue"),
        LIGHT_GRAY("light_gray"),
        LIME("lime"),
        MAGENTA("magenta"),
        ORANGE("orange"),
        PINK("pink"),
        PURPLE("purple"),
        WHITE("white"),
        YELLOW("yellow");

        private final String name;

        private Color(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static Color fromName(String name) {
            Color[] colors;
            for (Color color : colors = Color.values()) {
                if (!color.name.equals(name)) continue;
                return color;
            }
            return RED;
        }

        public static Color fromDyeColor(class_1767 dyeColor) {
            return switch (dyeColor) {
                case class_1767.field_7963 -> BLACK;
                case class_1767.field_7966 -> BLUE;
                case class_1767.field_7957 -> BROWN;
                case class_1767.field_7955 -> CYAN;
                case class_1767.field_7944 -> GRAY;
                case class_1767.field_7942 -> GREEN;
                case class_1767.field_7951 -> LIGHT_BLUE;
                case class_1767.field_7967 -> LIGHT_GRAY;
                case class_1767.field_7961 -> LIME;
                case class_1767.field_7958 -> MAGENTA;
                case class_1767.field_7946 -> ORANGE;
                case class_1767.field_7954 -> PINK;
                case class_1767.field_7945 -> PURPLE;
                case class_1767.field_7952 -> WHITE;
                case class_1767.field_7947 -> YELLOW;
                default -> RED;
            };
        }

        public static Color fromWool(class_2248 block) {
            if (block == class_2246.field_10146) {
                return BLACK;
            }
            if (block == class_2246.field_10514) {
                return BLUE;
            }
            if (block == class_2246.field_10113) {
                return BROWN;
            }
            if (block == class_2246.field_10619) {
                return CYAN;
            }
            if (block == class_2246.field_10423) {
                return GRAY;
            }
            if (block == class_2246.field_10170) {
                return GREEN;
            }
            if (block == class_2246.field_10294) {
                return LIGHT_BLUE;
            }
            if (block == class_2246.field_10222) {
                return LIGHT_GRAY;
            }
            if (block == class_2246.field_10028) {
                return LIME;
            }
            if (block == class_2246.field_10215) {
                return MAGENTA;
            }
            if (block == class_2246.field_10095) {
                return ORANGE;
            }
            if (block == class_2246.field_10459) {
                return PINK;
            }
            if (block == class_2246.field_10259) {
                return PURPLE;
            }
            if (block == class_2246.field_10446) {
                return WHITE;
            }
            if (block == class_2246.field_10490) {
                return YELLOW;
            }
            return RED;
        }
    }
}

