/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToDarkSpotTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_2246;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_4215;

public final class GlareBeGrumpyAtDarkSpotTask
extends class_4097<GlareEntity> {
    private static final int MAX_GRUMPY_TICKS = 200;
    private static final float WITHING_DISTANCE = 2.0f;
    private int grumpyTicks;
    private final class_2394 particleEffect = new class_2388(class_2398.field_11217, class_2246.field_28678.method_9564());

    public GlareBeGrumpyAtDarkSpotTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), class_4141.field_18456), 200);
    }

    protected boolean shouldRun(class_3218 world, GlareEntity glare) {
        class_4208 darkSpotPos = glare.getDarkSpotPos();
        return GlareBeGrumpyAtDarkSpotTask.canBeGrumpyAtDarkSpot(glare) && darkSpotPos.method_19446().method_19769((class_2374)glare.method_19538(), 2.0);
    }

    protected void run(class_3218 world, GlareEntity glare, long time) {
        this.grumpyTicks = 0;
        glare.setGrumpy(true);
        class_4215.method_19554((class_1309)glare, (class_1309)glare.method_6177());
        this.applyGlowToHostileEntities(glare);
    }

    protected boolean shouldKeepRunning(class_3218 world, GlareEntity glare, long time) {
        class_4208 darkSpotPos = glare.getDarkSpotPos();
        return GlareBeGrumpyAtDarkSpotTask.canBeGrumpyAtDarkSpot(glare) && darkSpotPos.method_19446().method_19769((class_2374)glare.method_19538(), 2.0);
    }

    protected void keepRunning(class_3218 world, GlareEntity glare, long time) {
        ++this.grumpyTicks;
        class_4215.method_19554((class_1309)glare, (class_1309)glare.method_6177());
        if (!glare.isGrumpy()) {
            glare.setGrumpy(true);
        }
        if (this.grumpyTicks == 10) {
            glare.playGrumpinessSound();
        }
        if (this.grumpyTicks % 3 == 0 && glare.method_6051().method_43056()) {
            glare.playRustleSound();
        }
        if (this.grumpyTicks % 2 == 0 && glare.method_6051().method_43056()) {
            class_2388 particleEffect = new class_2388(class_2398.field_11217, class_2246.field_28678.method_9564());
            ParticleSpawner.spawnParticles((class_1309)glare, (class_2394)particleEffect, glare.method_6051().method_39332(4, 10), 0.1);
        }
    }

    protected void finishRunning(class_3218 world, GlareEntity glare, long time) {
        glare.setGrumpy(false);
        glare.method_18868().method_18875(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get());
        GlareBrain.setDarkSpotLocatingCooldown(glare);
    }

    private void applyGlowToHostileEntities(GlareEntity glare) {
        class_238 box = new class_238(glare.method_24515()).method_1014(24.0);
        List hostileEntities = glare.method_37908().method_18467(class_1588.class, box);
        for (class_1588 hostileEntity : hostileEntities) {
            this.applyGlowToEntity(hostileEntity);
        }
    }

    private void applyGlowToEntity(class_1588 entity) {
        entity.method_6092(new class_1293(class_1294.field_5912, 200));
    }

    public static boolean canBeGrumpyAtDarkSpot(GlareEntity glare) {
        return GlareTravelToDarkSpotTask.canTravelToDarkSpot(glare) && glare.method_6177() != null;
    }
}

