/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public final class WildfireShockwaveAttackTask
extends class_4097<WildfireEntity> {
    private static final int SHOCKWAVE_DURATION = 20;
    private static final int SHOCKWAVE_PHASE_ONE_END_TICK = 15;
    public static final float SHOCKWAVE_ATTACK_RANGE = 6.0f;
    private int shockwaveTicks;
    private class_1309 attackTarget;

    public WildfireShockwaveAttackTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22354, (Object)class_4141.field_18456, (Object)class_4140.field_22355, (Object)class_4141.field_18458, FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), (Object)class_4141.field_18457), 20);
    }

    protected boolean shouldRun(class_3218 world, WildfireEntity wildfire) {
        class_1309 nearestTarget = wildfire.method_18868().method_18904(class_4140.field_22354).orElse(null);
        if (nearestTarget == null) {
            nearestTarget = wildfire.method_18868().method_18904(class_4140.field_22355).orElse(null);
        }
        if (nearestTarget == null || wildfire.method_5739((class_1297)nearestTarget) > 6.0f || !nearestTarget.method_5805() || nearestTarget instanceof class_1657 && (nearestTarget.method_7325() || ((class_1657)nearestTarget).method_7337())) {
            return false;
        }
        this.attackTarget = nearestTarget;
        return true;
    }

    protected void run(class_3218 world, WildfireEntity wildfire, long time) {
        wildfire.method_18868().method_18875(class_4140.field_18445);
        wildfire.method_5942().method_6340();
        class_4215.method_19554((class_1309)wildfire, (class_1309)this.attackTarget);
        wildfire.method_5988().method_35111((class_1297)this.attackTarget);
        WildfireBrain.setAttackTarget(wildfire, this.attackTarget);
        wildfire.playShockwaveSound();
        this.shockwaveTicks = 0;
    }

    protected boolean shouldKeepRunning(class_3218 world, WildfireEntity wildfire, long time) {
        return this.shockwaveTicks <= 20;
    }

    protected void keepRunning(class_3218 world, WildfireEntity wildfire, long time) {
        wildfire.method_5988().method_35111((class_1297)this.attackTarget);
        if (this.shockwaveTicks < 15) {
            wildfire.method_5762(0.0, 0.075f, 0.0);
        } else if (this.shockwaveTicks == 15) {
            wildfire.method_18800(0.0, 0.0, 0.0);
        } else {
            wildfire.method_5762(0.0, -1.0, 0.0);
        }
        wildfire.method_5784(class_1313.field_6308, wildfire.method_18798());
        if (this.shockwaveTicks == 20) {
            List closeEntities = wildfire.method_37908().method_8333((class_1297)wildfire, wildfire.method_5829().method_1014(6.0), class_1301.field_6156);
            for (class_1297 closeEntity : closeEntities) {
                if (closeEntity.method_5864().method_20210(FriendsAndFoesTags.WILDFIRE_ALLIES)) continue;
                this.spawnShockwaveParticles(wildfire);
                wildfire.method_6121(closeEntity);
            }
        }
        ++this.shockwaveTicks;
    }

    private void spawnShockwaveParticles(WildfireEntity wildfire) {
        class_243 wildfirePosition = wildfire.method_19538();
        class_3218 serverWorld = (class_3218)wildfire.method_37908();
        int waveAmount = 4;
        int particleAmount = 64;
        float slice = (float)Math.PI * 2 / (float)particleAmount;
        for (int radius = 1; radius < waveAmount; ++radius) {
            for (int particleNumber = 0; particleNumber < particleAmount; ++particleNumber) {
                float angle = slice * (float)particleNumber;
                int x = (int)(wildfirePosition.method_10216() + (double)((float)radius * class_3532.method_15362((float)angle)));
                int y = (int)wildfirePosition.method_10214();
                int z = (int)(wildfirePosition.method_10215() + (double)((float)radius * class_3532.method_15374((float)angle)));
                serverWorld.method_14199((class_2394)class_2398.field_11237, (double)x, (double)((float)y + 0.2f * (float)radius), (double)z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void finishRunning(class_3218 world, WildfireEntity wildfire, long time) {
        WildfireBrain.setShockwaveAttackCooldown(wildfire);
    }
}

