/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemGoToHomePositionTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemGoTowardsLookTarget;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemLookAroundTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemSleepTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemStrollTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemWaitTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem.TuffGolemWanderAroundTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public final class TuffGolemBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super TuffGolemEntity>>> SENSORS;
    private static final UniformInt SLEEP_COOLDOWN_PROVIDER;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.m_21923_(MEMORY_MODULES, SENSORS);
        Brain brain = profile.m_22073_(dynamic);
        TuffGolemBrain.addCoreActivities((Brain<TuffGolemEntity>)brain);
        TuffGolemBrain.addHomeActivities((Brain<TuffGolemEntity>)brain);
        TuffGolemBrain.addIdleActivities((Brain<TuffGolemEntity>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void addCoreActivities(Brain<TuffGolemEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)((Object)new TuffGolemLookAroundTask(45, 90)), (Object)((Object)new TuffGolemWanderAroundTask()), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get())));
    }

    private static void addHomeActivities(Brain<TuffGolemEntity> brain) {
        brain.m_21903_(FriendsAndFoesActivities.TUFF_GOLEM_HOME.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new TuffGolemGoToHomePositionTask())), (Object)Pair.of((Object)1, (Object)((Object)new TuffGolemSleepTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addIdleActivities(Brain<TuffGolemEntity> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60)), (Object)3), (Object)Pair.of((Object)new RunSometimes((Behavior)new SetEntityLookTarget(FriendsAndFoesEntityTypes.COPPER_GOLEM.get(), 6.0f), UniformInt.m_146622_((int)30, (int)60)), (Object)2), (Object)Pair.of((Object)new RunSometimes((Behavior)new SetEntityLookTarget(FriendsAndFoesEntityTypes.TUFF_GOLEM.get(), 6.0f), UniformInt.m_146622_((int)30, (int)60)), (Object)2), (Object)Pair.of((Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20460_, 12.0f), UniformInt.m_146622_((int)30, (int)60)), (Object)1)))), (Object)Pair.of((Object)1, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)((Object)new TuffGolemWaitTask(60, 80)), (Object)2), (Object)Pair.of(new TuffGolemStrollTask(0.6f), (Object)1), (Object)Pair.of((Object)((Object)new TuffGolemGoTowardsLookTarget(0.6f, 2)), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivities(TuffGolemEntity tuffGolem) {
        tuffGolem.m_6274_().m_21926_((List)ImmutableList.of((Object)FriendsAndFoesActivities.TUFF_GOLEM_HOME.get(), (Object)Activity.f_37979_));
    }

    public static void resetSleepCooldown(TuffGolemEntity tuffGolem) {
        tuffGolem.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get());
    }

    public static void setSleepCooldown(TuffGolemEntity tuffGolem) {
        tuffGolem.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)SLEEP_COOLDOWN_PROVIDER.m_214085_(tuffGolem.m_217043_()));
    }

    static {
        SENSORS = List.of(SensorType.f_26811_, SensorType.f_26812_);
        MEMORY_MODULES = List.of(MemoryModuleType.f_148205_, MemoryModuleType.f_26377_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26326_, FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get());
        SLEEP_COOLDOWN_PROVIDER = UniformInt.m_146622_((int)6000, (int)8000);
    }
}

