/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class WildfireShockwaveAttackTask
extends Behavior<WildfireEntity> {
    private static final int SHOCKWAVE_DURATION = 20;
    private static final int SHOCKWAVE_PHASE_ONE_END_TICK = 15;
    public static final float SHOCKWAVE_ATTACK_RANGE = 6.0f;
    private int shockwaveTicks;
    private LivingEntity attackTarget;

    public WildfireShockwaveAttackTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148206_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.REGISTERED, FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), 20);
    }

    protected boolean shouldRun(ServerLevel world, WildfireEntity wildfire) {
        LivingEntity nearestTarget = wildfire.m_6274_().m_21952_(MemoryModuleType.f_148206_).orElse(null);
        if (nearestTarget == null) {
            nearestTarget = wildfire.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
        }
        if (nearestTarget == null || wildfire.m_20270_((Entity)nearestTarget) > 6.0f || !nearestTarget.m_6084_() || nearestTarget instanceof Player && (nearestTarget.m_5833_() || ((Player)nearestTarget).m_7500_())) {
            return false;
        }
        this.attackTarget = nearestTarget;
        return true;
    }

    protected void run(ServerLevel world, WildfireEntity wildfire, long time) {
        wildfire.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        wildfire.m_21573_().m_26573_();
        BehaviorUtils.m_22595_((LivingEntity)wildfire, (LivingEntity)this.attackTarget);
        wildfire.m_21563_().m_148051_((Entity)this.attackTarget);
        WildfireBrain.setAttackTarget(wildfire, this.attackTarget);
        wildfire.playShockwaveSound();
        this.shockwaveTicks = 0;
    }

    protected boolean shouldKeepRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        return this.shockwaveTicks <= 20;
    }

    protected void keepRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        wildfire.m_21563_().m_148051_((Entity)this.attackTarget);
        if (this.shockwaveTicks < 15) {
            wildfire.m_5997_(0.0, 0.075f, 0.0);
        } else if (this.shockwaveTicks == 15) {
            wildfire.m_20334_(0.0, 0.0, 0.0);
        } else {
            wildfire.m_5997_(0.0, -1.0, 0.0);
        }
        wildfire.m_6478_(MoverType.SELF, wildfire.m_20184_());
        if (this.shockwaveTicks == 20) {
            List closeEntities = wildfire.m_9236_().m_6249_((Entity)wildfire, wildfire.m_20191_().m_82400_(6.0), EntitySelector.f_20406_);
            for (Entity closeEntity : closeEntities) {
                if (closeEntity.m_6095_().m_204039_(FriendsAndFoesTags.WILDFIRE_ALLIES)) continue;
                this.spawnShockwaveParticles(wildfire);
                wildfire.m_7327_(closeEntity);
            }
        }
        ++this.shockwaveTicks;
    }

    private void spawnShockwaveParticles(WildfireEntity wildfire) {
        Vec3 wildfirePosition = wildfire.m_20182_();
        ServerLevel serverWorld = (ServerLevel)wildfire.m_9236_();
        int waveAmount = 4;
        int particleAmount = 64;
        float slice = (float)Math.PI * 2 / (float)particleAmount;
        for (int radius = 1; radius < waveAmount; ++radius) {
            for (int particleNumber = 0; particleNumber < particleAmount; ++particleNumber) {
                float angle = slice * (float)particleNumber;
                int x = (int)(wildfirePosition.m_7096_() + (double)((float)radius * Mth.m_14089_((float)angle)));
                int y = (int)wildfirePosition.m_7098_();
                int z = (int)(wildfirePosition.m_7094_() + (double)((float)radius * Mth.m_14031_((float)angle)));
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)x, (double)((float)y + 0.2f * (float)radius), (double)z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void finishRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        WildfireBrain.setShockwaveAttackCooldown(wildfire);
    }
}

