/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.util;

import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class TotemUtil {
    private static final int MAX_ILLUSIONS_COUNT = 9;
    private static final int ILLUSION_LIFETIME_TICKS = 600;
    private static final int NEGATIVE_EFFECT_TICKS = 400;
    public static final int POSITIVE_EFFECT_TICKS = 200;
    private static final Predicate<LivingEntity> FREEZE_FILTER = entity -> !(entity instanceof Player) || !((Player)entity).m_7500_();
    private static final TargetingConditions FREEZE_TARGET_PREDICATE = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(FREEZE_FILTER);
    private static final TargetingConditions ATTACK_TARGET_PREDICATE = TargetingConditions.m_148353_().m_26893_().m_148355_();

    public static void playActivateAnimation(ItemStack itemStack, Entity entity, ParticleType<?> particleType) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        minecraftClient.f_91061_.m_107332_(entity, (ParticleOptions)particleType, 30);
        ClientLevel clientWorld = minecraftClient.f_91073_;
        if (clientWorld != null) {
            clientWorld.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, entity.m_5720_(), 1.0f, 1.0f, false);
        }
        if (entity == minecraftClient.f_91074_) {
            minecraftClient.f_91063_.m_109113_(itemStack);
        }
    }

    public static void freezeEntities(Player player) {
        List nearbyEntities = player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_(9.0), livingEntity -> FREEZE_TARGET_PREDICATE.m_26885_((LivingEntity)player, livingEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            nearbyEntity.m_146917_(400);
            nearbyEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 400, 1));
        });
    }

    public static void createIllusions(Player player) {
        player.m_5496_(FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), 1.0f, player.m_6100_());
        Vec3 illusionerPosition = player.m_20182_();
        float slice = 0.69813174f;
        int radius = 9;
        ArrayList<PlayerIllusionEntity> createdPlayerIllusions = new ArrayList<PlayerIllusionEntity>();
        for (int point = 0; point < 9; ++point) {
            int z;
            int y;
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.m_7096_() + (double)((float)radius * Mth.m_14089_((float)angle)));
            PlayerIllusionEntity createdPlayerIllusion = TotemUtil.createIllusion(player, x, y = (int)illusionerPosition.m_7098_(), z = (int)(illusionerPosition.m_7094_() + (double)((float)radius * Mth.m_14031_((float)angle))));
            if (createdPlayerIllusion == null) continue;
            createdPlayerIllusions.add(createdPlayerIllusion);
        }
        List nearbyEntities = player.m_9236_().m_6443_(Mob.class, player.m_20191_().m_82400_(18.0), mobEntity -> ATTACK_TARGET_PREDICATE.m_26885_((LivingEntity)player, (LivingEntity)mobEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            if (nearbyEntity.m_5448_() == player) {
                if (!createdPlayerIllusions.isEmpty()) {
                    nearbyEntity.m_21561_(true);
                    nearbyEntity.m_6703_((LivingEntity)createdPlayerIllusions.get(player.m_217043_().m_188503_(createdPlayerIllusions.size())));
                    nearbyEntity.m_21335_((Entity)createdPlayerIllusions.get(player.m_217043_().m_188503_(createdPlayerIllusions.size())));
                }
                nearbyEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 400, 1));
            }
        });
        if (!createdPlayerIllusions.isEmpty()) {
            LivingEntity attacker;
            PlayerIllusionEntity illusionToReplace = (PlayerIllusionEntity)((Object)createdPlayerIllusions.get(player.m_217043_().m_188503_(createdPlayerIllusions.size())));
            boolean teleportResult = TotemUtil.tryToTeleport(player, illusionToReplace.m_146903_(), illusionToReplace.m_146904_(), illusionToReplace.m_146907_());
            if (teleportResult) {
                TotemUtil.spawnCloudParticles(player);
            }
            if ((attacker = illusionToReplace.m_21188_()) != null) {
                illusionToReplace.m_6598_(null);
                illusionToReplace.m_6703_(null);
                illusionToReplace.m_21335_(null);
            }
            illusionToReplace.m_146870_();
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 200));
    }

    @Nullable
    private static PlayerIllusionEntity createIllusion(Player player, int x, int y, int z) {
        float randomYaw;
        PlayerIllusionEntity playerIllusion = (PlayerIllusionEntity)FriendsAndFoesEntityTypes.PLAYER_ILLUSION.get().m_20615_(player.m_9236_());
        if (playerIllusion == null) {
            return null;
        }
        playerIllusion.prevCapeX = player.f_36102_;
        playerIllusion.prevCapeY = player.f_36103_;
        playerIllusion.prevCapeZ = player.f_36104_;
        playerIllusion.capeX = player.f_36105_;
        playerIllusion.capeY = player.f_36106_;
        playerIllusion.capeZ = player.f_36075_;
        playerIllusion.prevStrideDistance = player.f_36099_;
        playerIllusion.strideDistance = player.f_36100_;
        playerIllusion.m_8061_(EquipmentSlot.MAINHAND, player.m_21205_().m_41777_());
        playerIllusion.m_8061_(EquipmentSlot.OFFHAND, player.m_21206_().m_41777_());
        player.m_6168_().forEach(item -> playerIllusion.m_21540_(item.m_41777_()));
        playerIllusion.m_21153_(player.m_21233_());
        playerIllusion.m_20359_((Entity)player);
        playerIllusion.f_19859_ = randomYaw = 360.0f * player.m_217043_().m_188501_();
        playerIllusion.m_146922_(randomYaw);
        playerIllusion.f_20884_ = randomYaw;
        playerIllusion.m_5618_(randomYaw);
        playerIllusion.f_20886_ = randomYaw;
        playerIllusion.m_5616_(randomYaw);
        playerIllusion.setPlayerUuid(player.m_20148_());
        playerIllusion.setPlayer(player);
        playerIllusion.setTicksUntilDespawn(600);
        boolean teleportResult = playerIllusion.tryToTeleport(x, y, z);
        if (teleportResult) {
            player.m_9236_().m_7967_((Entity)playerIllusion);
            playerIllusion.spawnCloudParticles();
        }
        return playerIllusion;
    }

    private static boolean tryToTeleport(Player player, int x, int y, int z) {
        double bottomY = Math.max(y -= 8, player.m_9236_().m_141937_());
        double topY = Math.min(bottomY + 16.0, (double)(((ServerLevel)player.m_9236_()).m_143344_() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = player.m_20984_((double)x, (double)(y = (int)Mth.m_14008_((double)(y + 1), (double)bottomY, (double)topY)), (double)z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private static void spawnCloudParticles(Player player) {
        TotemUtil.spawnParticles(player, ParticleTypes.f_123796_, 16);
    }

    private static void spawnParticles(Player player, SimpleParticleType particleType, int amount) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)particleType, player.m_20208_(0.5), player.m_20187_() + 0.5, player.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

