/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareBeGrumpyAtDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareLocateDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareLocateGlowBerriesTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareShakeGlowBerriesTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareStrollTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTeleportToOwnerTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToGlowBerriesTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSensorTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1856;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4101;
import net.minecraft.class_4102;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4115;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4121;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4802;
import net.minecraft.class_4806;
import net.minecraft.class_4815;
import net.minecraft.class_4821;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_5754;
import net.minecraft.class_6019;
import net.minecraft.class_7297;

public final class GlareBrain {
    public static final List<class_4140<?>> MEMORY_MODULES;
    public static final List<class_4149<? extends class_4148<? super GlareEntity>>> SENSORS;
    private static final class_6019 DARK_SPOT_LOCATING_COOLDOWN_PROVIDER;
    private static final class_6019 EAT_GLOW_BERRIES_COOLDOWN_PROVIDER;

    public static class_4095<?> create(Dynamic<?> dynamic) {
        class_4095.class_5303 profile = class_4095.method_28311(MEMORY_MODULES, SENSORS);
        class_4095 brain = profile.method_28335(dynamic);
        GlareBrain.addCoreActivities((class_4095<GlareEntity>)brain);
        GlareBrain.addAvoidActivities((class_4095<GlareEntity>)brain);
        GlareBrain.addIdleActivities((class_4095<GlareEntity>)brain);
        GlareBrain.addDarkSpotActivities((class_4095<GlareEntity>)brain);
        GlareBrain.addGlowBerriesActivities((class_4095<GlareEntity>)brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(class_4095<GlareEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(class_4140.field_38397), (Object)new class_5753(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get()), (Object)new class_5753(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get())));
    }

    private static void addDarkSpotActivities(class_4095<GlareEntity> brain) {
        brain.method_24529(FriendsAndFoesActivities.GLARE_SHOW_DARK_SPOT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GlareLocateDarkSpotTask())), (Object)Pair.of((Object)1, (Object)((Object)new GlareTravelToDarkSpotTask())), (Object)Pair.of((Object)2, (Object)((Object)new GlareBeGrumpyAtDarkSpotTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_18448, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_28325, (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), (Object)class_4141.field_18456), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)class_4141.field_18457), (Object[])new Pair[0]));
    }

    private static void addGlowBerriesActivities(class_4095<GlareEntity> brain) {
        brain.method_24529(FriendsAndFoesActivities.GLARE_EAT_GLOW_BERRIES.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_4815(glare -> true, 1.25f, true, 32)), (Object)Pair.of((Object)1, (Object)((Object)new GlareLocateGlowBerriesTask())), (Object)Pair.of((Object)2, (Object)((Object)new GlareTravelToGlowBerriesTask())), (Object)Pair.of((Object)3, (Object)((Object)new GlareShakeGlowBerriesTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_18448, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_28325, (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)class_4141.field_18457)));
    }

    private static void addAvoidActivities(class_4095<GlareEntity> brain) {
        brain.method_24529(class_4168.field_22399, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4121.method_24603((class_4140)class_4140.field_22357, (float)1.25f, (int)16, (boolean)false))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18456), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)class_4141.field_18457)));
    }

    private static void addIdleActivities(class_4095<GlareEntity> brain) {
        brain.method_24529(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_5754(glare -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)new class_4806(FriendsAndFoesEntityTypes.GLARE.get(), 1.0f)), (Object)Pair.of((Object)2, (Object)new class_5355(class_6019.method_35017((int)5, (int)16), 1.25f)), (Object)Pair.of((Object)3, (Object)((Object)new GlareTeleportToOwnerTask())), (Object)Pair.of((Object)4, (Object)new class_7297(glare -> GlareBrain.getOwner((GlareEntity)glare), 3, 8, 2.0f)), (Object)Pair.of((Object)5, (Object)new class_4821((class_4097)new class_4119(glare -> true, 3.0f), class_6019.method_35017((int)30, (int)60))), (Object)Pair.of((Object)6, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)new class_4120(1.0f, 3), (Object)3), (Object)Pair.of((Object)((Object)new GlareStrollTask()), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)class_4141.field_18456), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)class_4141.field_18456)));
    }

    private static Optional<class_4115> getOwner(GlareEntity glare) {
        if (!glare.method_6181() || glare.method_6177() == null) {
            return Optional.empty();
        }
        return Optional.of(new class_4102((class_1297)glare.method_6177(), true));
    }

    public static void updateActivities(GlareEntity glare) {
        glare.method_18868().method_24531((List)ImmutableList.of((Object)FriendsAndFoesActivities.GLARE_SHOW_DARK_SPOT.get(), (Object)FriendsAndFoesActivities.GLARE_EAT_GLOW_BERRIES.get(), (Object)class_4168.field_22399, (Object)class_4168.field_18595));
    }

    public static void updateMemories(GlareEntity glare) {
        if ((!glare.method_6109() && !glare.method_6181() || !GlareLocateDarkSpotTask.canLocateDarkSpot(glare)) && glare.method_18868().method_18876(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), class_4141.field_18457)) {
            GlareBrain.setDarkSpotLocatingCooldown(glare);
        }
        if (glare.method_24345() || glare.method_5934() || glare.method_5765()) {
            glare.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)true);
        } else {
            glare.method_18868().method_18875(FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get());
        }
        if (glare.method_6181()) {
            glare.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), (Object)true);
        } else {
            glare.method_18868().method_18875(FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get());
        }
    }

    public static void setDarkSpotLocatingCooldown(GlareEntity glare) {
        glare.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)DARK_SPOT_LOCATING_COOLDOWN_PROVIDER.method_35008(glare.method_6051()));
    }

    public static void setDarkSpotLocatingCooldown(GlareEntity glare, class_6019 cooldown) {
        glare.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)cooldown.method_35008(glare.method_6051()));
    }

    public static void setLocatingGlowBerriesCooldown(GlareEntity glare) {
        glare.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)EAT_GLOW_BERRIES_COOLDOWN_PROVIDER.method_35008(glare.method_6051()));
    }

    public static void setLocatingGlowBerriesCooldown(GlareEntity glare, class_6019 cooldown) {
        glare.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)cooldown.method_35008(glare.method_6051()));
    }

    public static void setItemPickupCooldown(GlareEntity glare) {
        glare.method_18868().method_18878(class_4140.field_38397, (Object)class_4802.method_24505((int)1, (int)10).method_35008(glare.method_6051()));
    }

    public static class_1856 getTemptItems() {
        return class_1856.method_8106(FriendsAndFoesTags.GLARE_TEMPT_ITEMS);
    }

    static {
        SENSORS = List.of(class_4149.field_18466, class_4149.field_18467, class_4149.field_22358, class_4149.field_25362, FriendsAndFoesSensorTypes.GLARE_TEMPTATIONS.get(), FriendsAndFoesSensorTypes.GLARE_SPECIFIC_SENSOR.get());
        MEMORY_MODULES = List.of(class_4140.field_39408, class_4140.field_28325, class_4140.field_28326, class_4140.field_38397, class_4140.field_39408, class_4140.field_28327, class_4140.field_18442, class_4140.field_18449, class_4140.field_18446, class_4140.field_18445, class_4140.field_22350, class_4140.field_18448, class_4140.field_22357, class_4140.field_19293, class_4140.field_22332, FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get());
        DARK_SPOT_LOCATING_COOLDOWN_PROVIDER = class_4802.method_24505((int)20, (int)40);
        EAT_GLOW_BERRIES_COOLDOWN_PROVIDER = class_4802.method_24505((int)30, (int)60);
    }
}

