/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.tuffgolem;

import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.TuffGolemBrain;
import com.faboslav.friendsandfoes.common.entity.pose.TuffGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1308;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4141;

public final class TuffGolemSleepTask
extends class_4097<TuffGolemEntity> {
    private static final int MIN_TICKS_TO_SLEEP = 6000;
    private static final int MAX_TICKS_TO_SLEEP = 12000;

    public TuffGolemSleepTask() {
        super((Map)ImmutableMap.of(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get(), (Object)class_4141.field_18457), 6000, 12000);
    }

    protected boolean shouldRun(class_3218 world, TuffGolemEntity tuffGolem) {
        return tuffGolem.isAtHome() && tuffGolem.getKeyframeAnimationTicks() == 0 && tuffGolem.method_18868().method_18904(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get()).isEmpty();
    }

    protected void run(class_3218 world, TuffGolemEntity tuffGolem, long time) {
        tuffGolem.method_33574(tuffGolem.getHomePos());
        tuffGolem.setSpawnYaw(tuffGolem.getHomeYaw());
        if (tuffGolem.method_41328(TuffGolemEntityPose.STANDING.get())) {
            tuffGolem.startSleeping();
        } else if (tuffGolem.method_41328(TuffGolemEntityPose.STANDING_WITH_ITEM.get())) {
            tuffGolem.startSleepingWithItem();
        }
    }

    protected boolean shouldKeepRunning(class_3218 world, TuffGolemEntity tuffGolem, long time) {
        return tuffGolem.isInSleepingPose() && tuffGolem.method_18868().method_18904(FriendsAndFoesMemoryModuleTypes.TUFF_GOLEM_SLEEP_COOLDOWN.get()).isEmpty();
    }

    protected void finishRunning(class_3218 world, TuffGolemEntity tuffGolem, long time) {
        TuffGolemBrain.setSleepCooldown(tuffGolem);
        MovementUtil.stopMovement((class_1308)tuffGolem);
        if (tuffGolem.method_41328(TuffGolemEntityPose.SLEEPING.get())) {
            tuffGolem.startStanding();
        } else if (tuffGolem.method_41328(TuffGolemEntityPose.SLEEPING_WITH_ITEM.get())) {
            tuffGolem.startStandingWithItem();
        }
    }
}

