/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.BlockClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BlockEntangledChalice;
import org.cyclops.evilcraft.block.BlockEntangledChaliceConfigClient;
import org.cyclops.evilcraft.item.ItemEntangledChalice;

public class BlockEntangledChaliceConfig
extends BlockConfigCommon<ModBaseNeoForge<?>> {
    @ConfigurablePropertyCommon(category="machine", comment="If the fluid should be rendered statically. Fluids won't be shown fluently, but more efficiently.", requiresMcRestart=true)
    public static boolean staticBlockRendering = false;

    public BlockEntangledChaliceConfig() {
        super((IModBase)EvilCraft._instance, "entangled_chalice", (eConfig, properties) -> new BlockEntangledChalice(properties.requiresCorrectToolForDrops().strength(2.5f).sound(SoundType.STONE)), (eConfig, block) -> new ItemEntangledChalice((Block)block, eConfig.createDefaultItemProperties()));
        EvilCraft._instance.getModEventBus().addListener(this::registerCapability);
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    protected void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new ItemEntangledChalice.FluidHandler((ItemStack)stack, 4000), new ItemLike[]{(ItemLike)this.getInstance()});
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        NonNullList list = NonNullList.create();
        ((BlockEntangledChalice)this.getInstance()).fillItemCategory((NonNullList<ItemStack>)list);
        return list;
    }

    public BlockClientConfig<ModBaseNeoForge<?>> constructBlockClientConfig() {
        return new BlockEntangledChaliceConfigClient(this);
    }
}

