/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.AABB;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.advancement.criterion.BoxOfEternalClosureCaptureTrigger;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;

public class BlockEntityBoxOfEternalClosure
extends CyclopsBlockEntity {
    public static final float START_LID_ANGLE = 65.0f;
    private static final int TICK_MODULUS = 10;
    private static final int TARGET_RADIUS = 10;
    private static final double ABSORB_RADIUS = 0.5;
    private static final int NO_TARGET = -1;
    private static final float LID_STEP = 11.5f;
    public int innerRotation;
    @NBTPersist
    private CompoundTag spiritTag = new CompoundTag();
    @NBTPersist
    private String playerId = "";
    @NBTPersist
    private String playerName = "";
    private EntityVengeanceSpiritData spiritData = null;
    private EntityVengeanceSpirit targetSpirit = null;
    @NBTPersist(useDefaultValue=false)
    private Integer targetSpiritId = -1;
    @NBTPersist(useDefaultValue=false)
    private Float lidAngle = Float.valueOf(65.0f);
    private float previousLidAngle = 65.0f;
    private State state = State.UNKNOWN;

    public BlockEntityBoxOfEternalClosure(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BOX_OF_ETERNAL_CLOSURE.get(), blockPos, blockState);
        this.innerRotation = new Random().nextInt(100000);
    }

    @Nullable
    public static EntityType<?> getSpiritType(ItemStack itemStack) {
        return EntityVengeanceSpiritData.getSpiritType(itemStack);
    }

    public CompoundTag getSpiritTag() {
        if (this.spiritTag == null) {
            this.spiritTag = new CompoundTag();
        }
        return this.spiritTag;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
        this.setChanged();
        this.sendUpdate();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
        this.setChanged();
        this.sendUpdate();
    }

    public void setSpiritTag(CompoundTag tag) {
        this.spiritTag = tag;
        this.setChanged();
        this.sendUpdate();
    }

    public boolean isClosed() {
        return this.getState() == State.CLOSED;
    }

    public State getState() {
        if (this.state == State.UNKNOWN) {
            this.updateState();
        }
        return this.state;
    }

    private void setState(State newState) {
        if (newState != this.state) {
            State oldState = this.state;
            this.state = newState;
            this.onStateChanged(oldState, this.state);
        }
    }

    private void updateState() {
        if (this.lidAngle.floatValue() <= 0.0f) {
            this.setState(State.CLOSED);
        } else if (this.lidAngle.floatValue() >= 65.0f) {
            this.setState(State.OPEN);
        }
    }

    private void onStateChanged(State oldState, State newState) {
        if (oldState == State.UNKNOWN) {
            return;
        }
        switch (this.state.ordinal()) {
            case 1: {
                this.onBoxOpened();
                break;
            }
            case 4: {
                this.onBoxClosed();
                break;
            }
            case 2: {
                this.onBoxOpening();
                break;
            }
            case 3: {
                this.onBoxClosing();
                break;
            }
        }
    }

    private void onBoxOpened() {
        if (!this.level.isClientSide() && this.hasSpirit()) {
            this.releaseSpirit();
        }
    }

    private void onBoxClosed() {
    }

    private void onBoxOpening() {
        if (this.level.isClientSide()) {
            this.playOpenSound();
        }
    }

    private void onBoxClosing() {
        if (this.level.isClientSide()) {
            this.playCloseSound();
        }
    }

    public boolean hasSpirit() {
        return !this.getSpiritTag().isEmpty();
    }

    private void releaseSpirit() {
        EntityVengeanceSpirit spirit = this.createNewVengeanceSpirit();
        this.level.addFreshEntity((Entity)spirit);
        this.clearSpirit();
    }

    private void playOpenSound() {
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, pitch);
    }

    private void playCloseSound() {
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, pitch);
    }

    private EntityVengeanceSpirit createNewVengeanceSpirit() {
        RandomSource rand = this.level.random;
        EntityVengeanceSpirit spirit = EntityVengeanceSpirit.fromNBT(this.getLevel(), this.getSpiritTag());
        spirit.setPos((double)this.getBlockPos().getX() + rand.nextDouble(), (double)this.getBlockPos().getY() + rand.nextDouble(), (double)this.getBlockPos().getZ() + rand.nextDouble());
        spirit.setFrozenDuration(0);
        spirit.setGlobalVengeance(true);
        spirit.setRemainingLife(Mth.nextInt((RandomSource)this.level.random, (int)250, (int)1000));
        return spirit;
    }

    private void clearSpirit() {
        this.spiritTag = new CompoundTag();
        this.spiritData = null;
    }

    private float randomFloat(float min, float max) {
        return min + this.level.random.nextFloat() * max;
    }

    private void playSound(SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.level.playLocalSound((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), sound, category, volume, pitch, false);
    }

    public void open() {
        this.setState(State.OPENING);
    }

    public void close() {
        this.setState(State.CLOSING);
    }

    public void closeImmediately() {
        this.setState(State.CLOSED);
    }

    public void initializeState() {
        if (this.hasSpirit()) {
            this.setState(State.CLOSED);
        } else {
            this.setState(State.OPEN);
        }
    }

    private void initializeLidAngle() {
        if (this.getState() == State.OPEN) {
            this.lidAngle = Float.valueOf(65.0f);
            this.previousLidAngle = this.lidAngle.floatValue();
        } else if (this.getState() == State.CLOSED) {
            this.lidAngle = Float.valueOf(0.0f);
            this.previousLidAngle = this.lidAngle.floatValue();
        }
    }

    private void setSpirit(EntityVengeanceSpirit spirit) {
        this.setSpiritTag(IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(spirit.getData()::writeNBT, (HolderLookup.Provider)spirit.level().registryAccess()));
    }

    private void updateLidAngle() {
        State state = this.getState();
        this.previousLidAngle = this.lidAngle.floatValue();
        if (state == State.OPENING) {
            this.incrementLidAngle(11.5f);
        } else if (state == State.CLOSING) {
            this.incrementLidAngle(-11.5f);
        }
        if (state == State.OPENING || state == State.CLOSING) {
            this.updateState();
        }
    }

    private void pullEntity() {
        EntityVengeanceSpirit target = this.getTargetSpirit();
        if (target != null) {
            double dx = this.targetSpirit.getX() - (double)this.getBlockPos().getX() - 0.5;
            double dy = this.targetSpirit.getY() - (double)this.getBlockPos().getY() - 0.5;
            double dz = this.targetSpirit.getZ() - (double)this.getBlockPos().getZ() - 0.5;
            double distance = Mth.sqrt((float)((float)(dx * dx + dy * dy + dz * dz)));
            if (!target.isAlive() || !target.isFrozen()) {
                this.setTargetSpirit(null);
            } else {
                BlockPos blockPos = this.getBlockPos();
                AABB boxBoundingBox = this.getBlockState().getCollisionShape((BlockGetter)this.level, blockPos).move((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()).bounds();
                AABB spiritBoundingBox = target.getBoundingBox().inflate(0.5);
                boolean spiritTrapped = spiritBoundingBox.intersects(boxBoundingBox);
                if (spiritTrapped) {
                    this.captureSpirit(this.targetSpirit);
                    this.close();
                } else {
                    double strength = 1.0 / distance / 50.0 + 0.01;
                    target.setDeltaMovement(target.getDeltaMovement().subtract(dx * strength, dy * strength, dz * strength));
                }
            }
        }
    }

    public void captureSpirit(EntityVengeanceSpirit targetSpirit) {
        for (ServerPlayer player : targetSpirit.getEntanglingPlayers()) {
            ((BoxOfEternalClosureCaptureTrigger)((Object)RegistryEntries.TRIGGER_BOX_OF_ETERNAL_CLOSURE_CAPTURE.get())).test(player, (Entity)targetSpirit.getInnerEntity());
        }
        targetSpirit.remove(Entity.RemovalReason.DISCARDED);
        this.playerId = targetSpirit.getPlayerId();
        this.playerName = targetSpirit.getPlayerName();
        this.setSpirit(targetSpirit);
        this.setTargetSpirit(null);
        this.close();
    }

    private boolean findsOrHasTargetEntity() {
        return this.hasTargetSpirit() || this.findsTargetEntity();
    }

    private boolean findsTargetEntity() {
        return IModHelpers.get().getWorldHelpers().efficientTick(this.getLevel(), 10, this.getBlockPos()) && this.findNextEntity();
    }

    private boolean hasTargetSpirit() {
        return this.getTargetSpirit() != null;
    }

    private void playBeamSound() {
        float volume = this.randomFloat(0.1f, 0.9f);
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound((SoundEvent)RegistryEntries.SOUNDEVENT_EFFECT_BOX_BEAM.get(), SoundSource.AMBIENT, volume, pitch);
    }

    private boolean findNextEntity() {
        AABB box = new AABB((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()).inflate(10.0, 10.0, 10.0);
        List entities = this.level.getEntitiesOfClass(EntityVengeanceSpirit.class, box);
        double minDistanceSquared = Math.pow(11.0, 2.0);
        EntityVengeanceSpirit closest = null;
        for (EntityVengeanceSpirit spirit : entities) {
            double distance;
            if (!spirit.isFrozen() || spirit.isSwarm() || !((distance = spirit.distanceToSqr(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ())) < minDistanceSquared)) continue;
            minDistanceSquared = distance;
            closest = spirit;
        }
        this.setTargetSpirit(closest);
        return this.targetSpirit != null;
    }

    protected void updateLight() {
        BlockState blockState = this.getLevel().getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, IModHelpers.get().getMinecraftHelpers().getBlockNotify() | IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
    }

    public float getLidAngle() {
        return this.lidAngle.floatValue();
    }

    private void setLidAngle(float newLidAngle) {
        if (newLidAngle != this.lidAngle.floatValue()) {
            this.lidAngle = Float.valueOf(newLidAngle);
            if (this.lidAngle.floatValue() < 0.0f) {
                this.lidAngle = Float.valueOf(0.0f);
                this.updateLight();
            } else if (this.lidAngle.floatValue() > 65.0f) {
                this.lidAngle = Float.valueOf(65.0f);
                this.updateLight();
            }
        }
    }

    private void incrementLidAngle(float increment) {
        this.setLidAngle(this.lidAngle.floatValue() + increment);
    }

    public float getPreviousLidAngle() {
        return this.previousLidAngle;
    }

    public EntityVengeanceSpirit getTargetSpirit() {
        if (this.getLevel().isClientSide() && this.targetSpiritId == -1) {
            this.targetSpirit = null;
        } else if (this.targetSpirit == null && this.targetSpiritId != -1) {
            this.setTargetSpirit((EntityVengeanceSpirit)this.getLevel().getEntity(this.targetSpiritId.intValue()));
        }
        return this.targetSpirit;
    }

    private void setTargetSpirit(EntityVengeanceSpirit targetSpirit) {
        EntityVengeanceSpirit old = this.targetSpirit;
        this.targetSpirit = targetSpirit;
        this.targetSpiritId = targetSpirit != null ? Integer.valueOf(targetSpirit.getId()) : Integer.valueOf(-1);
        if (old != targetSpirit) {
            this.sendUpdate();
        }
    }

    public EntityVengeanceSpiritData getSpiritData() {
        return this.hasSpirit() ? this.loadSpiritDataLazy() : null;
    }

    private EntityVengeanceSpiritData loadSpiritDataLazy() {
        if (this.spiritData == null) {
            this.spiritData = EntityVengeanceSpiritData.fromNBT(this.getSpiritTag(), (HolderLookup.Provider)this.level.registryAccess());
        }
        return this.spiritData;
    }

    public void read(ValueInput input) {
        super.read(input);
        this.initializeState();
        this.initializeLidAngle();
    }

    public static enum State {
        UNKNOWN,
        OPEN,
        OPENING,
        CLOSING,
        CLOSED;

    }

    public static class TickerClient
    extends BlockEntityTickerDelayed<BlockEntityBoxOfEternalClosure> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityBoxOfEternalClosure blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            ++blockEntity.innerRotation;
            if (blockEntity.hasTargetSpirit()) {
                blockEntity.playBeamSound();
            }
            blockEntity.updateLidAngle();
        }
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityBoxOfEternalClosure> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityBoxOfEternalClosure blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            ++blockEntity.innerRotation;
            if (!blockEntity.hasSpirit() && blockEntity.findsOrHasTargetEntity()) {
                blockEntity.pullEntity();
            }
            blockEntity.updateLidAngle();
        }

        protected void onSendUpdate(Level level, BlockPos pos) {
            super.onSendUpdate(level, pos);
            level.updateNeighborsAt(pos, level.getBlockState(pos).getBlock());
        }
    }
}

