/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDisplayStand;

public class BlockEntityDisplayStand
extends CyclopsBlockEntity {
    @NBTPersist
    private ItemStack displayStandType;
    @NBTPersist
    private boolean directionPositive = false;
    private final SimpleInventory inventory = new SimpleInventory(1, 1);

    public BlockEntityDisplayStand(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DISPLAY_STAND.get(), blockPos, blockState);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void onDirty() {
        super.onDirty();
        this.sendUpdate();
    }

    public Direction.AxisDirection getDirection() {
        return this.directionPositive ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    public void setDirection(Direction.AxisDirection direction) {
        this.directionPositive = direction == Direction.AxisDirection.POSITIVE;
        this.sendUpdate();
    }

    public void setDisplayStandType(ItemStack displayStandType) {
        this.displayStandType = displayStandType;
        this.sendUpdate();
    }

    public ItemStack getDisplayStandType() {
        return this.displayStandType;
    }

    protected Direction getFacing() {
        return (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(this.getLevel().getBlockState(this.getBlockPos()), BlockDisplayStand.FACING, (Comparable)Direction.NORTH);
    }

    protected ItemStack getContents() {
        return this.inventory.getItem(0);
    }

    public void read(ValueInput input) {
        super.read(input);
        this.inventory.readFromNBT(input, "inventory");
    }

    public void saveAdditional(ValueOutput output) {
        this.inventory.writeToNBT(output, "inventory");
        super.saveAdditional(output);
    }

    public void onDataPacket(Connection net, ValueInput valueInput) {
        super.onDataPacket(net, valueInput);
        this.onUpdateReceived();
    }

    public void onUpdateReceived() {
        IModHelpers.get().getBlockHelpers().markForUpdate(this.level, this.worldPosition);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        IModHelpers.get().getInventoryHelpers().dropItems(this.getLevel(), (Container)this.getInventory(), pos);
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntityDisplayStand> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityDisplayStand>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> new InvWrapper((Container)blockEntity.getInventory()));
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> (IFluidHandler)blockEntity.getContents().getCapability(Capabilities.FluidHandler.ITEM));
        }
    }
}

