/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import net.minecraft.client.model.AbstractZombieModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.cyclops.evilcraft.entity.monster.EntityControlledZombie;
import org.cyclops.evilcraft.entity.monster.EntityControlledZombieConfig;

public class RenderControlledZombie
extends HumanoidMobRenderer<EntityControlledZombie, ZombieRenderState, AbstractZombieModel<ZombieRenderState>> {
    private final ResourceLocation texture;

    public RenderControlledZombie(EntityControlledZombieConfig config, EntityRendererProvider.Context renderContext) {
        super(renderContext, (HumanoidModel)new Model(renderContext), 0.5f);
        this.texture = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)("textures/entity/" + config.getNamedId() + ".png"));
    }

    public ResourceLocation getTextureLocation(ZombieRenderState renderState) {
        return this.texture;
    }

    public ZombieRenderState createRenderState() {
        return new ZombieRenderState();
    }

    public void extractRenderState(EntityControlledZombie entity, ZombieRenderState state, float partialTick) {
        super.extractRenderState((Mob)entity, (HumanoidRenderState)state, partialTick);
        state.isAggressive = entity.isAggressive();
        state.isConverting = false;
    }

    public static class Model
    extends AbstractZombieModel<ZombieRenderState> {
        protected Model(EntityRendererProvider.Context context) {
            super(context.bakeLayer(ModelLayers.ZOMBIE));
        }
    }
}

