/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.cyclops.evilcraft.client.render.entity.RenderStateDarkStick;
import org.cyclops.evilcraft.entity.item.EntityItemDarkStick;
import org.joml.Quaternionfc;

public class RenderDarkStick
extends EntityRenderer<EntityItemDarkStick, RenderStateDarkStick> {
    private final ItemModelResolver itemModelResolver;

    public RenderDarkStick(EntityRendererProvider.Context renderContext) {
        super(renderContext);
        this.itemModelResolver = renderContext.getItemModelResolver();
    }

    public RenderStateDarkStick createRenderState() {
        return new RenderStateDarkStick();
    }

    public void extractRenderState(EntityItemDarkStick entity, RenderStateDarkStick state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        state.ageInTicks = (float)entity.getAge() + partialTick;
        state.bobOffset = entity.bobOffs;
        state.shouldBob = IClientItemExtensions.of((ItemStack)entity.getItem()).shouldBobAsEntity(entity.getItem());
        state.shouldSpread = IClientItemExtensions.of((ItemStack)entity.getItem()).shouldSpreadAsEntity(entity.getItem());
        state.extractItemGroupRenderState((Entity)entity, entity.getItem(), this.itemModelResolver);
        state.valid = entity.isValid();
        state.angle = entity.getAngle();
    }

    public void render(RenderStateDarkStick renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
        float rotation = renderState.valid ? renderState.angle : (renderState.ageInTicks / 20.0f + renderState.bobOffset) * 57.295776f;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(25.0f));
        ((EntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().renderers.get(EntityType.ITEM)).render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
    }
}

