/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradable;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.config.extendedconfig.UpgradableBlockContainerConfig;
import org.cyclops.evilcraft.item.ItemPromise;

public abstract class BlockEntityWorking<T extends BlockEntityWorking<T, O>, O>
extends BlockEntityTickingTankInventory<T>
implements IUpgradable<T, O> {
    public static final int INVENTORY_SIZE_UPGRADES = 4;
    private int basicInventorySize;
    private Map<Upgrades.Upgrade, Integer> levels = null;
    protected Map<Upgrades.Upgrade, IUpgradeBehaviour<T, O>> upgradeBehaviour = Maps.newHashMap();
    protected boolean hasJustWorked;

    public BlockEntityWorking(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize, int stackSize, int tankSize, Fluid acceptedFluid) {
        super(type, blockPos, blockState, inventorySize + 4, stackSize, tankSize, acceptedFluid);
        this.basicInventorySize = inventorySize;
    }

    public int getBasicInventorySize() {
        return this.basicInventorySize;
    }

    public abstract Metadata getTileWorkingMetadata();

    public abstract boolean canWork();

    public boolean isWorking() {
        return this.getWorkTick() > 0;
    }

    public boolean isVisuallyWorking() {
        return this.getCurrentState() == 1 && this.canWork();
    }

    public int getWorkTickScaled(int scale) {
        return (int)Math.ceil((float)(this.getWorkTick() + 1) / this.getRequiredWorkTicks() * (float)scale);
    }

    protected abstract int getWorkTicker();

    protected int getWorkTick() {
        return this.getTickers().get(this.getWorkTicker()).getTick();
    }

    protected float getRequiredWorkTicks() {
        return this.getTickers().get(this.getWorkTicker()).getRequiredTicks();
    }

    public void resetWork() {
        this.resetWork(true);
    }

    public void resetWork(boolean hardReset) {
        if (hardReset) {
            this.getTickers().get(this.getWorkTicker()).setTick(0);
            this.getTickers().get(this.getWorkTicker()).setRequiredTicks(0.0f);
        }
    }

    @Override
    public int getNewState() {
        return this.isWorking() ? 1 : 0;
    }

    @Override
    protected boolean hasJustWorked() {
        return this.hasJustWorked;
    }

    @Override
    public void onStateChanged() {
        this.setChanged();
    }

    protected List<ItemStack> getUpgradeItems() {
        LinkedList itemStacks = Lists.newLinkedList();
        for (int i = this.basicInventorySize; i < this.basicInventorySize + 4; ++i) {
            ItemStack itemStack = this.getInventory().getItem(i);
            if (itemStack.isEmpty()) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    protected void resetUpgradeLevels() {
        this.levels = null;
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new Inventory<T>(this, inventorySize, stackSize, this){

            public boolean canPlaceItemThroughFace(int slot, ItemStack itemStack, Direction side) {
                return super.canPlaceItemThroughFace(slot, itemStack, side) && this.canPlaceItemThroughFace(slot, itemStack, side);
            }

            public boolean canTakeItemThroughFace(int slot, ItemStack itemStack, Direction side) {
                return super.canTakeItemThroughFace(slot, itemStack, side) && this.canTakeItemThroughFace(slot, itemStack, side);
            }
        };
    }

    public Map<Upgrades.Upgrade, Integer> getUpgradeLevels() {
        if (this.levels == null) {
            this.levels = Maps.newHashMap();
            for (ItemStack itemStack : this.getUpgradeItems()) {
                Upgrades.Upgrade upgrade = this.getUpgradeType(itemStack);
                int level = this.getUpgradeLevel(itemStack);
                if (this.levels.containsKey(upgrade)) {
                    level += this.levels.get(upgrade).intValue();
                }
                this.levels.put(upgrade, level);
            }
        }
        return this.levels;
    }

    @Override
    public Map<Upgrades.Upgrade, IUpgradeBehaviour<T, O>> getUpgradeBehaviour() {
        return this.upgradeBehaviour;
    }

    public Upgrades.Upgrade getUpgradeType(ItemStack itemStack) {
        if (itemStack.getItem() instanceof ItemPromise) {
            Upgrades.Upgrade upgrade = ((ItemPromise)itemStack.getItem()).getUpgrade(itemStack);
            if (this.getTileWorkingMetadata().getUpgrades().contains(upgrade)) {
                return upgrade;
            }
        }
        return null;
    }

    public int getUpgradeLevel(ItemStack itemStack) {
        return itemStack.getCount();
    }

    public boolean onUpgradeSlotChanged(int slotId, ItemStack oldItemStack, ItemStack itemStack) {
        if (!ItemStack.matches((ItemStack)oldItemStack, (ItemStack)itemStack)) {
            this.resetUpgradeLevels();
            this.resetWork();
            if (!this.level.isClientSide()) {
                this.getTank().setCapacity(BlockEntityWorking.getTankTierMultiplier(this.getTileWorkingMetadata().getTier((Container)this.getInventory())) * this.tankSize);
            }
            this.setChanged();
            return true;
        }
        return false;
    }

    public static int getTankTierMultiplier(int tier) {
        return 1 << tier * 2;
    }

    public static abstract class Metadata {
        private final int basicInventorySize;

        protected Metadata(int basicInventorySize) {
            this.basicInventorySize = basicInventorySize;
        }

        public int getBasicInventorySize() {
            return this.basicInventorySize;
        }

        public abstract boolean canConsume(ItemStack var1, Level var2);

        public boolean canInsertItem(Container inventory, int slot, ItemStack itemStack) {
            if (!this.isUpgradeSlot(slot)) {
                return true;
            }
            if (!(itemStack.getItem() instanceof ItemPromise) || !this.getUpgrades().contains(((ItemPromise)itemStack.getItem()).getUpgrade(itemStack))) {
                return false;
            }
            if (this.isTierUpgrade(itemStack) && this.isTierUpgrade(inventory.getItem(slot))) {
                return true;
            }
            if (this.isTierUpgrade(inventory.getItem(slot))) {
                return this.areUpgradeSlotsValidForTier(inventory, 0);
            }
            if (this.isTierUpgrade(itemStack)) {
                return this.getTier(inventory) == 0 && this.getRequiredTierForSlot(slot) <= ((ItemPromise)itemStack.getItem()).getUpgrade(itemStack).getTier();
            }
            return this.isUpgradeSlotEnabled(inventory, slot);
        }

        public boolean canExtractItem(Container inventory, int slot, ItemStack itemStack, ItemStack replaceItem) {
            if (!this.isUpgradeSlot(slot)) {
                return true;
            }
            if (this.isTierUpgrade(itemStack) && this.isTierUpgrade(replaceItem)) {
                int currentTier;
                int newTier = ((ItemPromise)replaceItem.getItem()).getUpgrade(replaceItem).getTier();
                return newTier >= (currentTier = ((ItemPromise)itemStack.getItem()).getUpgrade(itemStack).getTier()) || this.areUpgradeSlotsValidForTier(inventory, newTier);
            }
            if (this.isTierUpgrade(itemStack)) {
                return this.areUpgradeSlotsValidForTier(inventory, 0);
            }
            return true;
        }

        protected boolean isUpgradeSlot(int slotId) {
            return slotId >= this.basicInventorySize && slotId < this.basicInventorySize + 4;
        }

        protected boolean isTierUpgrade(ItemStack itemStack) {
            return itemStack.getItem() instanceof ItemPromise && ((ItemPromise)itemStack.getItem()).isTierUpgrade(itemStack);
        }

        protected boolean areUpgradeSlotsValidForTier(Container inventory, int tier) {
            for (int i = this.basicInventorySize + tier + 1; i < this.basicInventorySize + 4; ++i) {
                ItemStack itemStack = inventory.getItem(i);
                if (itemStack.isEmpty() || itemStack.getItem() instanceof ItemPromise && ((ItemPromise)itemStack.getItem()).isTierUpgrade(itemStack)) continue;
                return false;
            }
            return true;
        }

        public boolean isUpgradeSlotEnabled(Container inventory, int slotId) {
            return this.getRequiredTierForSlot(slotId) <= this.getTier(inventory);
        }

        protected int getRequiredTierForSlot(int slotId) {
            if (!this.isUpgradeSlot(slotId)) {
                return 0;
            }
            return slotId - this.basicInventorySize;
        }

        public int getTier(Container inventory) {
            for (int i = this.basicInventorySize; i < this.basicInventorySize + 4; ++i) {
                ItemStack itemStack = inventory.getItem(i);
                if (!(itemStack.getItem() instanceof ItemPromise) || !((ItemPromise)itemStack.getItem()).isTierUpgrade(itemStack)) continue;
                return ((ItemPromise)itemStack.getItem()).getUpgrade(itemStack).getTier();
            }
            return 0;
        }

        public Set<Upgrades.Upgrade> getUpgrades() {
            return UpgradableBlockContainerConfig.getBlockUpgrades(this.getBlock());
        }

        protected abstract Block getBlock();
    }

    public static class TickerServer<T extends BlockEntityWorking<T, O>, O>
    extends BlockEntityTickingTankInventory.TickerServer<T> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            ((BlockEntityWorking)blockEntity).hasJustWorked = ((BlockEntityWorking)blockEntity).isWorking();
            super.update(level, pos, blockState, blockEntity);
        }
    }

    public static class Inventory<T extends BlockEntityWorking<T, ?>>
    extends SimpleInventory {
        protected final T tile;

        public Inventory(int size, int stackLimit, T tile) {
            super(size, stackLimit);
            this.tile = tile;
        }

        public ItemStack removeItem(int slotId, int count) {
            ItemStack itemStack = super.removeItem(slotId, count);
            if (((BlockEntityWorking)this.tile).getTileWorkingMetadata().isUpgradeSlot(slotId)) {
                ItemStack oldItemStack = itemStack.copy();
                oldItemStack.grow(count);
                ((BlockEntityWorking)this.tile).onUpgradeSlotChanged(slotId, oldItemStack, itemStack);
            }
            return itemStack;
        }

        public void setItem(int slotId, ItemStack itemStack) {
            ItemStack oldItemStack = this.getItem(slotId);
            if (!oldItemStack.isEmpty()) {
                oldItemStack = oldItemStack.copy();
            }
            super.setItem(slotId, itemStack);
            if (((BlockEntityWorking)this.tile).getTileWorkingMetadata().isUpgradeSlot(slotId)) {
                ((BlockEntityWorking)this.tile).onUpgradeSlotChanged(slotId, oldItemStack, itemStack);
            }
        }

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            return ((BlockEntityWorking)this.tile).getTileWorkingMetadata().isUpgradeSlot(slot) && ((BlockEntityWorking)this.tile).getTileWorkingMetadata().isUpgradeSlotEnabled((Container)((BlockEntityTankInventory)((Object)this.tile)).getInventory(), slot) || super.canPlaceItem(slot, itemStack);
        }
    }

    public static class CapabilityRegistrar<T extends BlockEntityWorking<T, O>, O>
    extends BlockEntityTickingTankInventory.CapabilityRegistrar<T> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends T>> blockEntityType) {
            super(blockEntityType);
        }
    }
}

