/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.IBroomModifierRegistry;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomModifiersContents;
import org.cyclops.evilcraft.core.broom.BroomPartModifier;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class BroomModifierRegistry
implements IBroomModifierRegistry {
    private final Map<ResourceLocation, BroomModifier> broomModifiers = Maps.newLinkedHashMap();
    private final Map<BroomModifier, IBroomPart> broomModifierParts = Maps.newHashMap();
    private final List<Pair<Supplier<ItemStack>, Map<BroomModifier, Float>>> broomItems = Lists.newArrayList();

    public BroomModifierRegistry() {
        EvilCraft._instance.getModEventBus().addListener(EventPriority.HIGHEST, this::beforeItemsRegistered);
        NeoForge.EVENT_BUS.addListener(this::onTooltipEvent);
    }

    @Override
    public BroomModifier registerModifier(BroomModifier modifier) {
        this.broomModifiers.put(modifier.getId(), modifier);
        BroomPartModifier broomPart = new BroomPartModifier(modifier);
        this.overrideDefaultModifierPart(modifier, broomPart);
        return modifier;
    }

    @Override
    @Nullable
    public BroomModifier getModifier(ResourceLocation id) {
        return this.broomModifiers.get(id);
    }

    @Override
    public void overrideDefaultModifierPart(BroomModifier modifier, @Nullable IBroomPart broomPart) {
        this.broomModifierParts.put(modifier, broomPart);
        if (broomPart != null) {
            BroomParts.REGISTRY.registerPart(broomPart);
        }
    }

    @Override
    @Nullable
    public IBroomPart getModifierPart(BroomModifier modifier) {
        return this.broomModifierParts.get(modifier);
    }

    @Override
    public void clearModifierItems() {
        this.broomItems.clear();
    }

    @Override
    public void registerModifiersItem(Map<BroomModifier, Float> modifiers, Supplier<ItemStack> item) {
        Objects.requireNonNull(item);
        this.broomItems.add((Pair<Supplier<ItemStack>, Map<BroomModifier, Float>>)Pair.of(item, modifiers));
    }

    @Override
    public void registerModifiersItem(BroomModifier modifier, float modifierValue, Supplier<ItemStack> item) {
        HashMap map = Maps.newHashMap();
        map.put(modifier, Float.valueOf(modifierValue));
        this.registerModifiersItem(map, item);
    }

    @Override
    public Map<BroomModifier, Float> getModifiersFromItem(ItemStack item) {
        for (Pair<Supplier<ItemStack>, Map<BroomModifier, Float>> entry : this.broomItems) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)((ItemStack)((Supplier)entry.getKey()).get()))) continue;
            return (Map)entry.getValue();
        }
        return null;
    }

    @Override
    public Map<ItemStack, Float> getItemsFromModifier(BroomModifier modifier) {
        HashMap modifiers = Maps.newHashMap();
        for (Pair<Supplier<ItemStack>, Map<BroomModifier, Float>> entry : this.broomItems) {
            for (Map.Entry itModifiers : ((Map)entry.getValue()).entrySet()) {
                if (itModifiers.getKey() != modifier) continue;
                modifiers.put((ItemStack)((Supplier)entry.getKey()).get(), (Float)itModifiers.getValue());
            }
        }
        return modifiers;
    }

    @Override
    public Collection<BroomModifier> getModifiers() {
        return Collections.unmodifiableCollection(this.broomModifiers.values());
    }

    @Override
    public Map<BroomModifier, Float> getModifiers(ItemStack broomStack) {
        if (broomStack != null) {
            HashMap modifiers = Maps.newHashMap();
            for (BroomModifier modifier : this.getModifiers()) {
                if (!modifier.isBaseModifier()) continue;
                modifiers.put(modifier, Float.valueOf(modifier.getDefaultValue()));
            }
            if (broomStack.has(RegistryEntries.COMPONENT_BROOM_MODIFIERS)) {
                modifiers.putAll(((BroomModifiersContents)broomStack.get(RegistryEntries.COMPONENT_BROOM_MODIFIERS)).getModifiers());
            }
            return modifiers;
        }
        return Collections.emptyMap();
    }

    @Override
    public void setModifiers(ItemStack broomStack, Map<BroomModifier, Float> modifiers) {
        broomStack.set(RegistryEntries.COMPONENT_BROOM_MODIFIERS, (Object)new BroomModifiersContents(modifiers));
        Collection<IBroomPart> parts = BroomParts.REGISTRY.getBroomParts(broomStack);
        for (Map.Entry<BroomModifier, Float> entry : modifiers.entrySet()) {
            if (!(entry.getValue().floatValue() > 0.0f)) continue;
            IBroomPart part = this.getModifierPart(entry.getKey());
            int tier = BroomModifier.getTier(entry.getKey(), entry.getValue().floatValue());
            if (part == null) continue;
            for (int i = 0; i < tier; ++i) {
                parts.add(part);
            }
        }
        BroomParts.REGISTRY.setBroomParts(broomStack, parts);
    }

    public void onTooltipEvent(ItemTooltipEvent event) {
        Map<BroomModifier, Float> modifiers;
        if (ItemBroomConfig.broomModifierTooltips && (modifiers = this.getModifiersFromItem(event.getItemStack())) != null) {
            if (IModHelpers.get().getMinecraftClientHelpers().isShifted()) {
                event.getToolTip().add(Component.translatable((String)"broom.modifiers.evilcraft.types").withStyle(ChatFormatting.ITALIC));
                for (Map.Entry<BroomModifier, Float> entry : modifiers.entrySet()) {
                    event.getToolTip().add(entry.getKey().getTooltipLine("  ", entry.getValue().floatValue(), 0.0f, false));
                }
            } else {
                event.getToolTip().add(Component.translatable((String)"broom.modifiers.evilcraft.shiftinfo").withStyle(ChatFormatting.ITALIC));
            }
        }
    }

    public void beforeItemsRegistered(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.BLOCK)) {
            this.broomModifiers.clear();
            this.broomModifierParts.clear();
            this.broomItems.clear();
        }
    }
}

