/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;

public class WorldSharedTank
extends SingleUseTank {
    public static final String NBT_TANKID = "tankID";
    protected String tankID = "";
    private int previousAmount = 0;

    public WorldSharedTank(int capacity) {
        super(capacity);
    }

    public void resetPreviousFluid() {
        this.previousAmount = this.getFluidAmount();
    }

    public int getPreviousAmount() {
        return this.previousAmount;
    }

    public void serialize(ValueOutput output) {
        super.serialize(output);
        output.putString(NBT_TANKID, this.tankID);
    }

    public void deserialize(ValueInput input) {
        super.deserialize(input);
        this.tankID = (String)input.getString(NBT_TANKID).orElseThrow();
    }

    protected void readWorldFluid() {
        this.fluid = WorldSharedTankCache.getInstance().getTankContent(this.tankID);
    }

    protected void writeWorldFluid() {
        if (!IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            WorldSharedTankCache.getInstance().setTankContent(this.tankID, this.fluid);
        }
    }

    public void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
        this.writeWorldFluid();
    }

    public FluidStack getFluid() {
        this.readWorldFluid();
        return super.getFluid();
    }

    public int getFluidAmount() {
        this.readWorldFluid();
        return super.getFluidAmount();
    }

    public int getSpace() {
        this.readWorldFluid();
        return super.getSpace();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        this.readWorldFluid();
        int ret = super.fill(resource, action);
        if (ret > 0 && action.execute()) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        this.readWorldFluid();
        FluidStack ret = super.drain(maxDrain, action);
        if (!ret.isEmpty() && action.execute()) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        this.readWorldFluid();
        FluidStack ret = super.drain(resource, action);
        if (!ret.isEmpty() && action.execute()) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public String getTankID() {
        return this.tankID;
    }

    public void setTankID(String tankID) {
        this.tankID = tankID;
    }

    public Fluid getAcceptedFluid() {
        Fluid fluid = this.getFluidType();
        return fluid == null ? Fluids.EMPTY : fluid;
    }

    protected boolean replaceInnerFluid() {
        return false;
    }
}

