/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.core.fluid.WorldStorageSharedTank;
import org.cyclops.evilcraft.network.packet.UpdateWorldSharedTankClientCachePacket;

public class WorldSharedTankCache {
    public static final int INTERPOLATION_TICK_OFFSET = 10;
    private static WorldSharedTankCache _instance = null;
    private Map<String, UpdateWorldSharedTankClientCachePacket> packetBuffer = Maps.newHashMap();
    private int tick = 0;

    private WorldSharedTankCache() {
    }

    public void reset() {
        this.packetBuffer = Maps.newHashMap();
        this.tick = 0;
    }

    public static WorldSharedTankCache getInstance() {
        if (_instance == null) {
            _instance = new WorldSharedTankCache();
        }
        return _instance;
    }

    protected String getMapID(String tankID) {
        return tankID + (IModHelpers.get().getMinecraftHelpers().isClientSide() ? "C" : "S");
    }

    protected String removeMapID(String mapID) {
        return mapID.substring(0, mapID.length() - 1);
    }

    public synchronized FluidStack getTankContent(String tankID) {
        return ((WorldStorageSharedTank)EvilCraft.sharedTanks.get()).getFluid(this.getMapID(tankID)).copy();
    }

    protected static boolean shouldRefreshFluid(FluidStack old, FluidStack newF) {
        return old.getAmount() != newF.getAmount();
    }

    public synchronized void setTankContent(String tankID, FluidStack fluidStack) {
        String key = this.getMapID(tankID);
        WorldStorageSharedTank sharedTanks = (WorldStorageSharedTank)EvilCraft.sharedTanks.get();
        boolean shouldRefresh = WorldSharedTankCache.shouldRefreshFluid(sharedTanks.getFluid(key), fluidStack);
        sharedTanks.setFluid(key, fluidStack.copy());
        if (!IModHelpers.get().getMinecraftHelpers().isClientSide() && shouldRefresh) {
            this.bufferPacket(tankID, new UpdateWorldSharedTankClientCachePacket(tankID, fluidStack));
        }
    }

    protected void bufferPacket(String tankID, UpdateWorldSharedTankClientCachePacket packet) {
        this.packetBuffer.put(tankID, packet);
    }

    public int getTickOffset() {
        return this.tick;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onTickServer(ServerTickEvent.Pre event) {
        this.onTick(event);
    }

    public void onTick(ServerTickEvent.Pre event) {
        ++this.tick;
        if (this.getTickOffset() > 10) {
            Iterator<Map.Entry<String, UpdateWorldSharedTankClientCachePacket>> it = this.packetBuffer.entrySet().iterator();
            while (it.hasNext()) {
                EvilCraft._instance.getPacketHandler().sendToAll((PacketBase)it.next().getValue());
                it.remove();
            }
            this.tick = 0;
        }
    }

    @SubscribeEvent
    public void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!IModHelpers.get().getMinecraftHelpers().isClientSide()) {
            for (Map.Entry<String, FluidStack> entry : ((WorldStorageSharedTank)EvilCraft.sharedTanks.get()).getEntries()) {
                EvilCraft._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateWorldSharedTankClientCachePacket(this.removeMapID(entry.getKey()), entry.getValue()), (ServerPlayer)event.getEntity());
            }
        }
    }
}

