/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemHelpers {
    private static final int MB_FILL_PERTICK = GeneralConfig.mbFlowRate;
    public static final String NBT_KEY_ENABLED = "enabled";
    private static ItemStack bloodBucket = null;

    public static boolean isActivated(ItemStack itemStack) {
        return !itemStack.isEmpty() && (Boolean)itemStack.getOrDefault(RegistryEntries.COMPONENT_ACTIVATED, (Object)false) != false;
    }

    public static void toggleActivation(ItemStack itemStack) {
        if (ItemHelpers.isActivated(itemStack)) {
            itemStack.remove(RegistryEntries.COMPONENT_ACTIVATED);
        } else {
            itemStack.set(RegistryEntries.COMPONENT_ACTIVATED, (Object)true);
        }
    }

    public static void updateAutoFill(IFluidHandlerItem toDrain, Level world, Entity entity, boolean fillBuckets) {
        FluidStack tickFluid;
        if (entity instanceof Player && !world.isClientSide() && !(tickFluid = toDrain.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
            Player player = (Player)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held = player.getItemInHand(hand);
                if (held.isEmpty() || !fillBuckets && held.getItem() == Items.BUCKET) continue;
                ItemStack toFill = held.split(1);
                ItemStack filled = ItemHelpers.tryFillContainerForPlayer(toDrain, toFill, tickFluid, player);
                if (!filled.isEmpty()) {
                    if (player.getItemInHand(hand).isEmpty()) {
                        player.setItemInHand(hand, filled);
                        continue;
                    }
                    player.addItem(filled);
                    continue;
                }
                held.grow(1);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IFluidHandlerItem toDrain, ItemStack toFill, FluidStack tickFluid, Player player) {
        int maxFill = MB_FILL_PERTICK;
        if (toFill.getItem() == Items.BUCKET) {
            maxFill = IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume();
        }
        if (!toFill.isEmpty() && toFill != toDrain.getContainer() && FluidUtil.getFluidHandler((ItemStack)toFill) != null && player.getUseItemRemainingTicks() == 0 && FluidUtil.tryFillContainer((ItemStack)toFill, (IFluidHandler)toDrain, (int)Math.min(maxFill, tickFluid.getAmount()), (Player)player, (boolean)false).isSuccess()) {
            return FluidUtil.tryFillContainer((ItemStack)toFill, (IFluidHandler)toDrain, (int)Math.min(maxFill, tickFluid.getAmount()), null, (boolean)true).getResult();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getBloodBucket() {
        if (bloodBucket == null) {
            bloodBucket = new ItemStack(RegistryEntries.ITEM_BUCKET_BLOOD);
        }
        return bloodBucket;
    }
}

