/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.effect;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.advancement.criterion.NecromanceTrigger;
import org.cyclops.evilcraft.entity.monster.EntityControlledZombie;

public class EntityNecromancersHead
extends ThrowableProjectile
implements ItemSupplier {
    private static final int DURATION = 200;
    private static final ItemStack RENDER_ITEM = new ItemStack((ItemLike)Items.SKELETON_SKULL);
    protected boolean observing = false;
    protected LivingEntity target = null;
    protected List<EntityControlledZombie> observables = Lists.newLinkedList();
    protected Class<? extends Mob> mobType = EntityControlledZombie.class;

    public EntityNecromancersHead(EntityType<? extends EntityNecromancersHead> type, Level world) {
        super(type, world);
    }

    public EntityNecromancersHead(Level world, double x, double y, double z) {
        super((EntityType)RegistryEntries.ENTITY_NECROMANCER_HEAD.get(), x, y, z, world);
    }

    public void setMobType(Class<? extends Mob> mobType) {
        this.mobType = mobType;
    }

    protected void spawnSwarm(LivingEntity necromancer, LivingEntity target) {
        Level world = target.level();
        int amount = world.random.nextInt(2) + 3;
        for (int i = 0; i < amount; ++i) {
            EntityControlledZombie mob = new EntityControlledZombie(world);
            if (!mob.canAttackType(target.getType())) continue;
            mob.copyPosition((Entity)necromancer);
            mob.move(MoverType.SELF, new Vec3((double)(world.random.nextInt(20) - 10), 0.0, (double)(world.random.nextInt(20) - 10)));
            if (EntityHelpers.spawnEntity((ServerLevelAccessor)((ServerLevel)world), (Mob)mob, (EntitySpawnReason)EntitySpawnReason.MOB_SUMMONED)) {
                this.observables.add(mob);
            }
            mob.setTarget(target);
            mob.setTtl(200);
        }
        this.target = target;
        this.setObserverMode();
        if (necromancer instanceof ServerPlayer) {
            ((NecromanceTrigger)((Object)RegistryEntries.TRIGGER_NECROMANCE_TRIGGER.get())).test((ServerPlayer)necromancer, (Entity)target);
        }
    }

    public void tick() {
        super.tick();
        if (this.observing && !this.level().isClientSide() && IModHelpers.get().getWorldHelpers().efficientTick(this.level(), 10, new int[0])) {
            if (!this.observables.isEmpty()) {
                Iterator<EntityControlledZombie> it = this.observables.iterator();
                while (it.hasNext()) {
                    EntityControlledZombie mob = it.next();
                    if (mob.isAlive() && this.target.isAlive()) continue;
                    if (mob.isAlive()) {
                        mob.remove(Entity.RemovalReason.DISCARDED);
                    }
                    it.remove();
                }
            }
            if (this.observables.isEmpty()) {
                this.observing = false;
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (!this.observing) {
            super.remove(removalReason);
        }
    }

    protected void setObserverMode() {
        this.observing = true;
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.setInvisible(true);
    }

    protected void onHit(HitResult position) {
        if (position.getType() == HitResult.Type.ENTITY && !this.observing && !this.level().isClientSide()) {
            ((EntityHitResult)position).getEntity().hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
            if (this.getOwner() instanceof ServerPlayer && this.getOwner() != ((EntityHitResult)position).getEntity() && ((EntityHitResult)position).getEntity() instanceof LivingEntity) {
                this.spawnSwarm((LivingEntity)this.getOwner(), (LivingEntity)((EntityHitResult)position).getEntity());
            } else {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public ItemStack getItem() {
        return RENDER_ITEM;
    }
}

