/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.logging.log4j.util.Strings;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public class EntityVengeanceSpiritData {
    private static final int SWARM_TIERS = 5;
    private static String NBTKEY_INNER_ENTITY = "innerEntity";
    private static String NBTKEY_REMAINING_LIFE = "remainingLife";
    private static String NBTKEY_FROZEN_DURATION = "frozenDuration";
    private static String NBTKEY_IS_SWARM = "isSwarm";
    private static String NBTKEY_SWARM_TIER = "swarmTier";
    private static String NBTKEY_BUILDUP_DURATION = "buildupDuration";
    private static String NBTKEY_PLAYER_ID = "playerId";
    private static String NBTKEY_PLAYER_NAME = "playerName";
    public static String NBTKEY_INNER_SPIRIT = NBTKEY_INNER_ENTITY;
    @Nullable
    private EntityType<?> innerEntityType;
    private int remainingLife;
    private int frozenDuration;
    private boolean isSwarm;
    private int swarmTier;
    private int buildupDuration;
    private String playerId;
    private String playerName;

    public EntityVengeanceSpiritData() {
        this(null, 0);
    }

    public EntityVengeanceSpiritData(EntityType<?> innerEntityType) {
        this(innerEntityType, 0);
    }

    public EntityVengeanceSpiritData(EntityType<?> innerEntityType, int swarmTier) {
        this.innerEntityType = innerEntityType;
        this.swarmTier = swarmTier;
        this.playerId = "";
        this.playerName = "";
    }

    public boolean isFrozen() {
        return this.getFrozenDuration() > 0;
    }

    public void addFrozenDuration(int amount) {
        this.setFrozenDuration(this.getFrozenDuration() + amount);
    }

    public boolean containsPlayer() {
        return this.getPlayerId() != null && !this.getPlayerId().isEmpty();
    }

    public boolean hasInnerEntity() {
        return this.getInnerEntityType() != null;
    }

    public void setRandomSwarmTier(Random random) {
        this.setSwarmTier(EntityVengeanceSpiritData.getRandomSwarmTier(random));
    }

    public void readNBT(ValueInput valueInput) {
        valueInput.getString(NBTKEY_INNER_ENTITY).ifPresent(innerEntityType -> this.setInnerEntityType((EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(ResourceLocation.parse((String)innerEntityType))));
        this.setRemainingLife((Integer)valueInput.getInt(NBTKEY_REMAINING_LIFE).orElseThrow());
        this.setFrozenDuration((Integer)valueInput.getInt(NBTKEY_FROZEN_DURATION).orElseThrow());
        this.setSwarm(valueInput.getBooleanOr(NBTKEY_IS_SWARM, false));
        this.setSwarmTier((Integer)valueInput.getInt(NBTKEY_SWARM_TIER).orElseThrow());
        this.setBuildupDuration((Integer)valueInput.getInt(NBTKEY_BUILDUP_DURATION).orElseThrow());
        this.setPlayerId((String)valueInput.getString(NBTKEY_PLAYER_ID).orElseThrow());
        this.setPlayerName((String)valueInput.getString(NBTKEY_PLAYER_NAME).orElseThrow());
    }

    public void writeNBT(ValueOutput valueOutput) {
        if (this.getInnerEntityType() != null) {
            valueOutput.putString(NBTKEY_INNER_ENTITY, BuiltInRegistries.ENTITY_TYPE.getKey(this.getInnerEntityType()).toString());
        }
        valueOutput.putInt(NBTKEY_REMAINING_LIFE, this.getRemainingLife());
        valueOutput.putInt(NBTKEY_FROZEN_DURATION, this.getFrozenDuration());
        valueOutput.putBoolean(NBTKEY_IS_SWARM, this.isSwarm());
        valueOutput.putInt(NBTKEY_SWARM_TIER, this.getSwarmTier());
        valueOutput.putInt(NBTKEY_BUILDUP_DURATION, this.getBuildupDuration());
        valueOutput.putString(NBTKEY_PLAYER_ID, this.getPlayerId());
        valueOutput.putString(NBTKEY_PLAYER_NAME, this.getPlayerName());
    }

    public UUID getPlayerUUID() {
        try {
            return UUID.fromString(this.getPlayerId());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static EntityType<?> getRandomInnerEntity(RandomSource rand) {
        List entities = BuiltInRegistries.ENTITY_TYPE.stream().filter(e -> e.getCategory() == MobCategory.MONSTER).collect(Collectors.toList());
        return (EntityType)entities.get(rand.nextInt(entities.size()));
    }

    public static int getRandomSwarmTier(Random rand) {
        return rand.nextInt(5);
    }

    @Nullable
    public static EntityType<?> getSpiritType(ItemStack itemStack) {
        String innerEntity;
        CompoundTag tag = (CompoundTag)itemStack.get(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA);
        if (tag != null && !tag.isEmpty() && !Strings.isEmpty((CharSequence)(innerEntity = (String)tag.getString(NBTKEY_INNER_SPIRIT).orElse(null)))) {
            return (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(ResourceLocation.parse((String)innerEntity));
        }
        return null;
    }

    public static EntityVengeanceSpiritData fromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        EntityVengeanceSpiritData data = new EntityVengeanceSpiritData();
        IModHelpers.get().getMinecraftHelpers().valueInputFromNbt(tag, lookupProvider, data::readNBT);
        return data;
    }

    @Nullable
    public EntityType<?> getInnerEntityType() {
        return this.innerEntityType;
    }

    public int getRemainingLife() {
        return this.remainingLife;
    }

    public int getFrozenDuration() {
        return this.frozenDuration;
    }

    public boolean isSwarm() {
        return this.isSwarm;
    }

    public int getSwarmTier() {
        return this.swarmTier;
    }

    public int getBuildupDuration() {
        return this.buildupDuration;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setInnerEntityType(@Nullable EntityType<?> innerEntityType) {
        this.innerEntityType = innerEntityType;
    }

    public void setRemainingLife(int remainingLife) {
        this.remainingLife = remainingLife;
    }

    public void setFrozenDuration(int frozenDuration) {
        this.frozenDuration = frozenDuration;
    }

    public void setSwarm(boolean isSwarm) {
        this.isSwarm = isSwarm;
    }

    public void setSwarmTier(int swarmTier) {
        this.swarmTier = swarmTier;
    }

    public void setBuildupDuration(int buildupDuration) {
        this.buildupDuration = buildupDuration;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }
}

