/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class GameTestsItemStacking {
    public static final String TEMPLATE_EMPTY = "evilcraft:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="evilcraft:empty10")
    public void testStackingBloodExtractorEmpty(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        hopper.setItem(0, new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR, 3));
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingBloodExtractorFilled(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        fluidHandler.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, 1000), IFluidHandler.FluidAction.EXECUTE);
        hopper.setItem(0, itemStack.copy());
        hopper.setItem(1, itemStack.copy());
        hopper.setItem(2, itemStack.copy());
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingBloodExtractorFilledAndDrained(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        ItemStack itemStack1 = new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
        ItemStack itemStack2 = new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
        ItemStack itemStack3 = new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack2).orElse(null);
        fluidHandler.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, 1000), IFluidHandler.FluidAction.EXECUTE);
        fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        hopper.setItem(0, itemStack1);
        hopper.setItem(1, itemStack2);
        hopper.setItem(2, itemStack3);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingBloodExtractorFilledToggled(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        fluidHandler.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, 1000), IFluidHandler.FluidAction.EXECUTE);
        ItemHelpers.toggleActivation(itemStack);
        hopper.setItem(0, itemStack.copy());
        hopper.setItem(1, itemStack.copy());
        hopper.setItem(2, itemStack.copy());
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingBloodExtractorToggledUntoggled(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        ItemStack itemStack1 = new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
        ItemStack itemStack2 = new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
        ItemStack itemStack3 = new ItemStack(RegistryEntries.ITEM_BLOOD_EXTRACTOR);
        ItemHelpers.toggleActivation(itemStack2);
        ItemHelpers.toggleActivation(itemStack2);
        hopper.setItem(0, itemStack1);
        hopper.setItem(1, itemStack2);
        hopper.setItem(2, itemStack3);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingDarkTankEmpty(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        hopper.setItem(0, new ItemStack(RegistryEntries.ITEM_DARK_TANK, 3));
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingDarkTankFilled(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        fluidHandler.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, 1000), IFluidHandler.FluidAction.EXECUTE);
        hopper.setItem(0, itemStack.copy());
        hopper.setItem(1, itemStack.copy());
        hopper.setItem(2, itemStack.copy());
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingDarkTankFilledAndDrained(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        ItemStack itemStack1 = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        ItemStack itemStack2 = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        ItemStack itemStack3 = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack2).orElse(null);
        fluidHandler.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, 1000), IFluidHandler.FluidAction.EXECUTE);
        fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        hopper.setItem(0, itemStack1);
        hopper.setItem(1, itemStack2);
        hopper.setItem(2, itemStack3);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingDarkTankFilledToggled(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        fluidHandler.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, 1000), IFluidHandler.FluidAction.EXECUTE);
        ItemHelpers.toggleActivation(itemStack);
        hopper.setItem(0, itemStack.copy());
        hopper.setItem(1, itemStack.copy());
        hopper.setItem(2, itemStack.copy());
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }

    @GameTest(template="evilcraft:empty10")
    public void testStackingDarkTankToggledUntoggled(GameTestHelper helper) {
        helper.setBlock(POS.above(), Blocks.HOPPER);
        helper.setBlock(POS, Blocks.CHEST);
        HopperBlockEntity hopper = (HopperBlockEntity)helper.getBlockEntity(POS.above(), HopperBlockEntity.class);
        ItemStack itemStack1 = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        ItemStack itemStack2 = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        ItemStack itemStack3 = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        ItemHelpers.toggleActivation(itemStack2);
        ItemHelpers.toggleActivation(itemStack2);
        hopper.setItem(0, itemStack1);
        hopper.setItem(1, itemStack2);
        hopper.setItem(2, itemStack3);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(POS, ChestBlockEntity.class);
        helper.succeedWhen(() -> helper.assertTrue(chest.getItem(0).getCount() == 3, (Component)Component.literal((String)"Stacking failed")));
    }
}

