/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.helper.ParticleHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemBloodExtractorConfig;
import org.cyclops.evilcraft.item.ItemVeinSword;
import org.cyclops.evilcraft.item.ItemVeinSwordConfig;

public class ItemBloodExtractor
extends ItemBloodContainer {
    public ItemBloodExtractor(Item.Properties properties) {
        super(properties, ItemBloodExtractorConfig.containerSize);
        this.setPlaceFluids(true);
        NeoForge.EVENT_BUS.addListener(this::bloodObtainEvent);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Block block = context.getLevel().getBlockState(context.getClickedPos()).getBlock();
        if (context.getPlayer().isCrouching() && block instanceof BlockBloodStain) {
            RandomSource random = context.getLevel().random;
            IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)context.getLevel(), context.getClickedPos(), Capabilities.FluidHandler.BLOCK).ifPresent(source -> {
                FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null), (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                if (!moved.isEmpty() && context.getLevel().isClientSide()) {
                    ParticleHelpers.spawnBloodSplashParticles(context.getLevel(), context.getClickedPos(), 5, 1 + random.nextInt(2));
                }
            });
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public boolean isFoil(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        IModHelpers.get().getL10NHelpers().addStatusInfo(tooltipAdder, ItemHelpers.isActivated(itemStack), this.getDescriptionId() + ".info.auto_supply");
    }

    @Override
    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!player.isCrouching()) {
            return super.use(world, player, hand);
        }
        BlockHitResult target = ItemBloodExtractor.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!(target != null && target.getType() != HitResult.Type.MISS || world.isClientSide())) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }

    public static void fillForAllBloodExtractors(Player player, int minimumMB, int maximumMB) {
        int toFill = minimumMB + player.getRandom().nextInt(Math.max(1, maximumMB - minimumMB));
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext() && toFill > 0) {
            ItemStack itemStack = it.next();
            if (itemStack.isEmpty() || !(itemStack.getItem() instanceof ItemBloodExtractor)) continue;
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            toFill -= fluidHandler.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, toFill), IFluidHandler.FluidAction.EXECUTE);
            it.replace(fluidHandler.getContainer());
        }
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill(FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null), (Level)level, entity, ItemBloodExtractorConfig.autoFillBuckets);
        }
        super.inventoryTick(itemStack, level, entity, slot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem();
    }

    public void bloodObtainEvent(LivingDeathEvent event) {
        Entity e = event.getSource().getEntity();
        if (e != null && e instanceof ServerPlayer && !e.level().isClientSide() && event.getEntity() != null) {
            float boost = 1.0f;
            ServerPlayer player = (ServerPlayer)e;
            InteractionHand hand = player.getUsedItemHand();
            if (hand != null && player.getItemInHand(hand) != null && player.getItemInHand(hand).getItem() instanceof ItemVeinSword) {
                boost = (float)ItemVeinSwordConfig.extractionBoost;
            }
            float health = event.getEntity().getMaxHealth();
            int minimumMB = Mth.floor((float)(health * (float)ItemBloodExtractorConfig.minimumMobMultiplier * boost));
            int maximumMB = Mth.floor((float)(health * (float)ItemBloodExtractorConfig.maximumMobMultiplier * boost));
            ItemBloodExtractor.fillForAllBloodExtractors((Player)player, minimumMB, maximumMB);
        }
    }
}

