/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ItemClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemBroom;
import org.cyclops.evilcraft.item.ItemBroomConfigClient;
import org.jetbrains.annotations.Nullable;

public class ItemBroomConfig
extends ItemConfigCommon<ModBaseNeoForge<?>> {
    @ConfigurablePropertyCommon(category="item", comment="The position to render the broom gui overlay at. (0=NE, 1=SE, 2=SW,3=NW)", isCommandable=true)
    public static int guiOverlayPosition = 1;
    @ConfigurablePropertyCommon(category="item", comment="The X offset for the broom gui overlay.", isCommandable=true)
    public static int guiOverlayPositionOffsetX = -15;
    @ConfigurablePropertyCommon(category="item", comment="The Y offset for the broom gui overlay.", isCommandable=true)
    public static int guiOverlayPositionOffsetY = -10;
    @ConfigurablePropertyCommon(category="item", comment="The blood usage in mB per tick.")
    public static int bloodUsage = 1;
    @ConfigurablePropertyCommon(category="item", comment="The blood usage in mB per block break.")
    public static int bloodUsageBlockBreak = 1;
    @ConfigurablePropertyCommon(category="item", comment="Show broom part tooltips on source items.")
    public static boolean broomPartTooltips = true;
    @ConfigurablePropertyCommon(category="item", comment="Show broom modifier tooltips on source items.")
    public static boolean broomModifierTooltips = false;

    public ItemBroomConfig() {
        super((IModBase)EvilCraft._instance, "broom", (eConfig, properties) -> new ItemBroom(properties.stacksTo(1)));
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    @Nullable
    public ItemClientConfig<ModBaseNeoForge<?>> constructItemClientConfig() {
        return new ItemBroomConfigClient(this);
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        return ((ItemBroom)this.getInstance()).getDefaultCreativeTabEntries();
    }
}

