/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemPrimedPendant;

public class ItemPrimedPendantConfig
extends ItemConfigCommon<IModBase> {
    private static final String DELIMITER = ";";
    @ConfigurablePropertyCommon(category="item", comment="The capacity of the pendant.", requiresMcRestart=true)
    public static int capacity = IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() * 5;
    @ConfigurablePropertyCommon(category="item", comment="The amount of Blood to drain after one effect application.", isCommandable=true)
    public static int usage = 10;
    @ConfigurablePropertyCommon(category="item", comment="Usage multipliers. Potion ids are first, followed by floating numbers. A number smaller than one blacklists that potion.")
    public static List<String> potionMultipliers = Lists.newArrayList((Object[])new String[]{"minecraft:health_boost;-1", "minecraft:regeneration;10"});

    public ItemPrimedPendantConfig() {
        super((IModBase)EvilCraft._instance, "primed_pendant", (eConfig, properties) -> new ItemPrimedPendant(properties.stacksTo(1)));
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    public static double getMultiplier(Holder<MobEffect> potion) {
        HashMap multipliers = Maps.newHashMap();
        multipliers.clear();
        for (String line : potionMultipliers) {
            String[] split = line.split(DELIMITER);
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a Primed Pendant potion multiplier config.");
            }
            if (!split[0].equals(potion.getRegisteredName())) continue;
            try {
                double multiplier = 1.0;
                try {
                    multiplier = Double.parseDouble(split[1]);
                }
                catch (NumberFormatException e) {
                    EvilCraft.clog("Invalid ratio '" + split[1] + "' in a Primed Pendant potion multiplier config, using 1.0.", Level.ERROR);
                }
                return multiplier;
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid line '" + line + "' found for a Primed Pendant potion multiplier config: " + split[0] + " is not a number; skipping.");
            }
        }
        return 1.0;
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        return ((ItemPrimedPendant)((Object)this.getInstance())).getDefaultCreativeTabEntries();
    }
}

