/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;

public class ItemPromise
extends Item {
    private final Upgrades.Upgrade upgrade;

    public ItemPromise(Item.Properties properties, Upgrades.Upgrade upgrade) {
        super(properties);
        this.upgrade = upgrade;
    }

    public int getMaxStackSize(ItemStack itemStack) {
        if (this.upgrade.getTier() > 0) {
            return 1;
        }
        return super.getMaxStackSize(itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        if (IModHelpers.get().getMinecraftClientHelpers().isShifted()) {
            tooltipAdder.accept((Component)Component.translatable((String)"item.evilcraft.promise.use_in").withStyle(ChatFormatting.DARK_GREEN));
            for (BlockConfigCommon upgradable : this.getUpgrade(itemStack).getUpgradables()) {
                tooltipAdder.accept((Component)Component.translatable((String)upgradable.getTranslationKey()).withStyle(ChatFormatting.ITALIC));
            }
        }
    }

    public Upgrades.Upgrade getUpgrade(ItemStack itemStack) {
        return this.upgrade;
    }

    public static Item getItem(int tier) {
        if (tier == 1) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER1);
        }
        if (tier == 2) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER2);
        }
        if (tier == 3) {
            return ItemPromise.getItem(Upgrades.UPGRADE_TIER3);
        }
        throw new IllegalStateException("Could not find an item for tier " + tier);
    }

    public static Item getItem(Upgrades.Upgrade upgrade) {
        if (upgrade == Upgrades.UPGRADE_TIER1) {
            return (Item)RegistryEntries.ITEM_PROMISE_TIER_1.get();
        }
        if (upgrade == Upgrades.UPGRADE_TIER2) {
            return (Item)RegistryEntries.ITEM_PROMISE_TIER_2.get();
        }
        if (upgrade == Upgrades.UPGRADE_TIER3) {
            return (Item)RegistryEntries.ITEM_PROMISE_TIER_3.get();
        }
        if (upgrade == Upgrades.UPGRADE_SPEED) {
            return (Item)RegistryEntries.ITEM_PROMISE_SPEED.get();
        }
        if (upgrade == Upgrades.UPGRADE_EFFICIENCY) {
            return (Item)RegistryEntries.ITEM_PROMISE_EFFICIENCY.get();
        }
        throw new IllegalStateException("Could not find an item for " + String.valueOf(upgrade));
    }

    public boolean isTierUpgrade(ItemStack itemStack) {
        return !itemStack.isEmpty() && this.upgrade.getTier() > 0;
    }
}

