/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.compress.utils.Lists;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.IInventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class RegistryExportableBloodInfuserRecipe
extends RegistryExportableRecipeAbstract<RecipeType<RecipeBloodInfuser>, RecipeBloodInfuser, IInventoryFluidTier> {
    protected RegistryExportableBloodInfuserRecipe() {
        super(() -> RegistryEntries.RECIPETYPE_BLOOD_INFUSER.get());
    }

    public JsonObject serializeRecipe(RecipeHolder<RecipeBloodInfuser> recipe) {
        return RegistryExportableBloodInfuserRecipe.serializeRecipeStatic((RecipeBloodInfuser)recipe.value());
    }

    public static JsonObject serializeRecipeStatic(RecipeBloodInfuser recipe) {
        JsonObject object = new JsonObject();
        object.addProperty("tier", (Number)recipe.getInputTier().orElse(0));
        object.addProperty("duration", (Number)recipe.getDuration());
        object.addProperty("xp", (Number)recipe.getXp().orElse(Float.valueOf(0.0f)));
        JsonObject inputObject = new JsonObject();
        List inputItems = recipe.getInputIngredient().map(i -> i.items().collect(Collectors.toList())).orElseGet(Lists::newArrayList);
        JsonArray arrayInputs = new JsonArray();
        for (Holder input : inputItems) {
            arrayInputs.add((JsonElement)IRegistryExportable.serializeItemStack((ItemStack)new ItemStack(input)));
        }
        inputObject.add("item", (JsonElement)arrayInputs);
        recipe.getInputFluid().ifPresent(inputFluid -> inputObject.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)inputFluid)));
        JsonObject outputObject = new JsonObject();
        ItemStack itemOutput = recipe.getOutputItemFirst();
        outputObject.add("item", (JsonElement)IRegistryExportable.serializeItemStack((ItemStack)itemOutput));
        object.add("input", (JsonElement)inputObject);
        object.add("output", (JsonElement)outputObject);
        return object;
    }
}

